package dressing.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import dressing.ui.util.EditorWindow;

public class ReportPreferencesEditorWindow extends EditorWindow {
	private ReportPreferencesComposite preferencesComposite;

	public ReportPreferencesEditorWindow(Shell parentShell) {
		super(parentShell, EditorWindow.executeAction); // or update/create depending on your use case
		setTitle("Préférences");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
        container.setLayout(new org.eclipse.swt.layout.GridLayout(1, false));

        preferencesComposite = new ReportPreferencesComposite(container, SWT.NONE);
        preferencesComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

        return container;
	}

	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub

	}
	@Override
	public boolean terminer() {
		if (super.terminer()) {
            preferencesComposite.savePreferences(); // save on apply
            finish();
            return true;
        }
        return false;
	}
	@Override
	protected Point getInitialSize() {
		// TODO Auto-generated method stub
		return new Point(500, 400);
	}
	@Override
	protected boolean isMaximized() {
		return false;
	}
}
