package tech.frsdev.shapes2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;

public class Panel2D extends JPanel 
{
	double step = 0.1;
	Piece2DDraw piece = null;
	Point start=new Point();
	public Panel2D() {
		setBackground(Color.WHITE);
		addMouseWheelListener(new MouseWheelListener() {

			@Override
			public void mouseWheelMoved(MouseWheelEvent arg0) {
				if (arg0.getWheelRotation() < 0) // Agrandir
				{
					piece.zoom(step);
				} else {
					piece.zoom(-step);
				}
				validate();
				repaint();
			}
		});
		addMouseListener(new MouseListener() {

			@Override
			public void mouseReleased(MouseEvent e) {
			}

			@Override
			public void mousePressed(MouseEvent e) {

				start = e.getPoint();
			}

			@Override
			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			@Override
			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			@Override
			public void mouseClicked(MouseEvent e) {
				// TODO Auto-generated method stub

			}

		});
		addMouseMotionListener(new MouseMotionListener() {

			@Override
			public void mouseMoved(MouseEvent e) {
				// TODO Auto-generated method stub
			}

			@Override
			public void mouseDragged(MouseEvent e) {
				// TODO Auto-generated method stub
				Point end = e.getPoint();
				Point translate = new Point(end.x - start.x, end.y - start.y);
				piece.translate(translate);
				start = end;
				validate();
				repaint();
			}
		});
	}

	public void changePerspective(PlanUsinage persplan)
	{
		System.out.println("Changing perspective to " + persplan);
		piece.setViewPerspective(persplan);
		updateDesign(piece.getPiece());
	}
	public void updateDesign(Piece2D selection) {
		// TODO Auto-generated method stub
		if(piece==null)
		piece = new Piece2DDraw(selection, getWidth(), getHeight());
		else
		{
			piece.setPiece(selection);	
			piece.setHeightbound(getHeight());
			piece.setWidthbound(getWidth());
		}
		
		
		piece.redifine();
		validate();
		repaint();
	}

	
	@Override
	public void paint(Graphics g) {
		// TODO Auto-generated method stub
		super.paint(g);
		Graphics2D g2d  = (Graphics2D)g;
		AffineTransform oldTransform = g2d.getTransform();
//		g2d.scale(zoom, zoom);
		g.setColor(Color.BLACK);
		
		if(piece!=null)
		{
			piece.draw(g2d);	
		}
	}
	
	public static void paintToFile(String path,Piece2DDraw piece) {
		
		File file = null;
		for(PlanUsinage perspective: PlanUsinage.values())
		if(piece!=null)
		{
			BufferedImage bi = new BufferedImage(piece.getWidthbound(), piece.getHeightbound(), BufferedImage.TYPE_INT_ARGB);
			Graphics2D g = (Graphics2D) bi.getGraphics();
			g.setColor(Color.BLACK);
			piece.setViewPerspective(perspective);
			piece.redifine();
			piece.draw(g);
			String pathX  =  path + File.separator + perspective.toString() + ".png";
			file = new File(pathX);
			if(!file.exists()) {
				file.getParentFile().mkdirs();
				try {
					file.createNewFile();
					ImageIO.write(bi, "png", file);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			
		}
	}
	
	
}