package supercad.scene.object2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Pixmap.Format;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ActionProcessor;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.DrawingHelper;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceScreen;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class KitchenElement2D extends Object2D {

	public KitchenElement2D(KitchenElement element) {
		super(element);
		try {
			adjustTextureAndColors();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public void adjustTextureAndColors() {
		if (topView) {
			this.textureRegion = (String) worldObject.getProperties().get("top-texture");
			String caissonType = ((KitchenElement) getWorldObject()).getDesignObject().getDesignCaissonType();
			if (caissonType.equals("BAS_COINS_L")) {
				setColorFromCaissonFamily();
				this.textureRegion = "BAS_COINS_L";
				SceneTexture sceneTexture = new SceneTexture(textureRegion);
				if (!ModelProvider.getTextures().contains(sceneTexture)) {
					Gdx.app.postRunnable(new Runnable() {
						@Override
						public void run() {
							Pixmap pix = new Pixmap(1024, 1024, Format.RGBA8888);
							pix.setColor(getColor());
							pix.fill();
							Texture texture = new Texture(pix);
							pix.dispose();
							sceneTexture.setTexture(texture);
							sceneTexture.setCategory(CATEGORY.VIEW);
							ModelProvider.addTexture(textureRegion, sceneTexture);

						}
					});
				}
			} else if (caissonType.contentEquals("HAUT_COINS_L")) {
				setColorFromCaissonFamily();
				this.textureRegion = "HAUT_COINS_L";
				SceneTexture sceneTexture = new SceneTexture(textureRegion);
				if (!ModelProvider.getTextures().contains(sceneTexture)) {
					Gdx.app.postRunnable(new Runnable() {
						@Override
						public void run() {
							Pixmap pix = new Pixmap(1024, 1024, Format.RGBA8888);
							pix.setColor(getColor());
							pix.fill();
							Texture texture = new Texture(pix);
							pix.dispose();
							sceneTexture.setTexture(texture);
							sceneTexture.setCategory(CATEGORY.VIEW);
							ModelProvider.addTexture(textureRegion, sceneTexture);

						}
					});

				}
			}
		} else {
			this.textureRegion = (String) getWorldObject().getProperties().get("front-texture");
		}
		hidden = false;
	}

	@Override
	protected void drawWallView(Batch batch) {
		if (!hidden) {
			calculateRotatedVertices();
			if (worldObject.isSelected()) {
				batch.end();
				DrawingHelper.drawRotatedEdges(this, batch, 3, Color.RED);
				batch.begin();
			}
			batch.draw(textureRegion().getTexture(), getX(), getY(), getWidth() / 2, getHeight() / 2, getWidth(),
					getHeight(), getScaleX(), getScaleY(), getRotation(), textureRegion().getRegionX(),
					textureRegion().getRegionY(), textureRegion().getRegionWidth(), textureRegion().getRegionHeight(),
					false, false);
		}

		if (worldObject.isSelected() || getWorldObject().isDrawInnerQuotations()
				|| ActionProcessor.isShowInnerQuotations()) {
			DrawingHelper.drawQuotations(this, batch);
		}
	}

	@Override
	protected void drawTopView(Batch batch) {
		Color borderColor = Color.BLACK;
		setColorFromCaissonFamily();
		batch.end();
		if (worldObject.isSelected()) {
			borderColor = Color.RED;
			DrawingHelper.drawDistanceLines(this, batch);
		}
		DrawingHelper.drawRotatedEdges(this, batch, 5, borderColor);
		batch.begin();
		if (!hidden) {
			if (((!((KitchenElement) worldObject).isCoin()
					|| !this.topView)) || worldObject.getType().equals(ObjectType.MODELED)) {
				batch.setColor(getColor());
				batch.draw(textureRegion().getTexture(), getX(), getY(), getWidth() / 2, getHeight() / 2, getWidth(),
						getHeight(), getScaleX(), getScaleY(), getRotation(), textureRegion().getRegionX(),
						textureRegion().getRegionY(), textureRegion().getRegionWidth(),
						textureRegion().getRegionHeight(), false, false);
			} else {
				batch.end();
				if (shapeDrawer == null)
					shapeDrawer = new ShapeDrawer(RoomController.getPolyBatch(), textureRegion());
				shapeDrawer.setTextureRegion(textureRegion());
				RoomController.getPolyBatch().setProjectionMatrix(batch.getProjectionMatrix().cpy());
				shapeDrawer.setColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
				RoomController.getPolyBatch().begin();
				shapeDrawer.filledPolygon(polygon);
				RoomController.getPolyBatch().end();
				batch.begin();
			}

			if (worldObject instanceof KitchenElement
					&& !((KitchenElement) worldObject).getDesignObject().getName().contains("L")
					&& !((KitchenElement) worldObject).getDesignObject().getName().contains("Angle")) {
				DrawingHelper.drawDoors(this, batch);
				batch.flush();
			}

			if (worldObject.getModel() != null && worldObject.getName() != null
					&& worldObject.getType().equals(ObjectType.MODELED) && (worldObject.getName().contains("Porte"))) {
				DrawingHelper.drawDoorsarc(this, batch);
			}

			if ((worldObject.isSelected() || getWorldObject().isDrawInnerQuotations()
					|| ActionProcessor.getProcessor().isShowInnerQuotations()) && !(worldObject instanceof Wall)) {
				DrawingHelper.drawQuotationsTopView(this, batch);
			}

			calculateAttachmentPosition();
//			if (worldObject.isSelected()) {
//				if (surroundingEdges == null)
//					calculateSurroundingEdges();
//				Vector2 vertex = new Vector2();
//				Edge closest = getClosestEdge(surroundingEdges, vertex);
//				Vector2 proj;
//				if (closest != null) {
//					float[] scales;
//					try {
//						AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
//						ScreenController controller = screen.getController();
//						scales = controller.getScales();
//					} catch (Exception e) {
//						e.printStackTrace();
//						scales = new float[] { 1, 1 };
//					}
//
//					proj = MathUtilities.projectPoint(vertex, closest.getV0(), closest.getV1());
//					Vector2 vect = new Vector2(vertex).sub(proj);
//					String val = (Math.round(vect.len() * scales[0] * 1000)) + "mm";
//					Vector2 pos = new Vector2(vertex).add(proj).scl(.5f);
//					DrawingHelper.drawCutLine(vertex, new Vector2(proj.x, proj.y), batch, Color.BLACK, 2);
//					DrawingHelper.drawText(val, new Vector3(pos, 0), 0, Color.BLACK, .5f, batch);
//				}
//			}
		}
	}

	private void setColorFromCaissonFamily() {
		int familyCode=((KitchenElement) worldObject).getCassonFamily();
		setColor((familyCode*10.0f+170)/255, (familyCode*10.0f+170)/255, (familyCode*10.0f+170)/255, 1.0f);
	}

	@Override
	public synchronized void calculateRotatedVertices() {
		rotatedVertices.clear();
		DesignObject3D designObject = ((KitchenElement) getWorldObject()).getDesignObject();
		if (designObject != null) {
			if(vertices == null)
				setVertices();
			for(int i = 0; i < vertices.length; i+=2) {
				this.rotatedVertices.add(new Vector2(vertices[i], vertices[i+1]));
			}
			updateOrigin();
			float rotation = getWorldObject().getRotation();
			if (Scene.game.getScreen() instanceof SurfaceScreen)
				rotation = 0;
			for (Vector2 vertex : rotatedVertices) {
				vertex.set(MathUtilities.rotate(absoluteOrigin, vertex, rotation));
			}

			this.normal = rotatedVertices.get(0).cpy().sub(rotatedVertices.get(1)).nor();
			this.direction = this.normal.cpy().rotate(90);
		}
		
	}

	@Override
	public void setVertices() {
		vertices = new float[] { getX(), getY(), getX(), getY() + getHeight(), getX() + getWidth(),
				getY() + getHeight(), getX() + getWidth(), getY() };
		KitchenElement kitchenElement = (KitchenElement) getWorldObject();
		DesignObject3D designObject = kitchenElement.getDesignObject();
		if (designObject != null && (designObject.getDesignCaissonType().equals("HAUT_COINS_L")
				|| designObject.getDesignCaissonType().equals("BAS_COINS_L"))) {
			try {
				float scale = getWidth() / getWorldObject().getRealWorldDimension().x;
				float depth = (float) designObject.getDesignProfondeur() * 0.001f * scale;
				vertices = new float[] { getX(), getY() + getHeight(), getX() + getWidth(), getY() + getHeight(),
						getX() + getWidth(), getY(), getX() + getWidth() - depth, getY(), getX() + getWidth() - depth,
						getY() + getHeight() - depth, getX(), getY() + getHeight() - depth };

			} catch (Exception e) {
				e.printStackTrace();
			}

		}
		if (designObject != null && (designObject.getDesignCaissonType().contentEquals("HAUT_COINS_ANGLE")
				|| designObject.getDesignCaissonType().contentEquals("BAS_COINS_ANGLE"))) {
			try {
				float scale = getWidth() / getWorldObject().getRealWorldDimension().z;
				float extrusionLength = (float) designObject.getDesignProfondeur() * 0.001f * scale;
				vertices = new float[] { getX(), getY(), getX(), getY() + getHeight(), getX() + getWidth(),
						getY() + getHeight(), getX() + getWidth(), getY() + getHeight() - extrusionLength,
						getX() + extrusionLength, getY() };

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (polygon == null)
			polygon = new Polygon();
		polygon.setVertices(vertices);
		polygon.setOrigin(getX() + 0.5f * getWidth(), getY() + 0.5f * getHeight());
		polygon.setRotation(this.worldObject.getRotation());
	}

}
