package dressing.ui.project;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.ui.internal.actions.ClearWorkingSetAction;
import org.osgi.service.event.EventHandler;

import dressing.model.DesignException;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import dressing.ui.util.OpenWizardDialog;
import gdxapp.scenes.SceneManager;

public class OpenProjectWizard extends Wizard {

	@Inject
	IEventBroker eventBroker;
	//0 for create 1 for open 
	private OpenProjectPage openPage;
	SuperCadProject project;

	public OpenProjectWizard() {
		
		setWindowTitle("Ouvrir un projet");
		
		OpenWizardDialog container=(OpenWizardDialog) getContainer();
//		if(container!=null) {
//			((OpenWizardDialog) container).getButton(IDialogConstants.FINISH_ID).setText("Terminer");
//			((OpenWizardDialog) container).getButton(IDialogConstants.CANCEL_ID).setText("Annuler");
//		}
	}
	
	@Override
	public boolean performFinish() {
		SuperCadProject currentProject = ProjectManager.getManager().getCurrentProject();
		if(currentProject!=null) {
			int answer=MessageDialog.open(MessageDialog.QUESTION_WITH_CANCEL, null, "Confirmation", "Vous les vous enregistrer le projet courant",SWT.NONE , "Oui","Non","Annuler");
			if(answer==0)
			{
				ProjectManager.getManager().saveProject(currentProject,false,false);
			}
			if(answer==2)
			{
				return true;
			}
		}
		this.project=this.openPage.getProject();
		ProjectManager.getManager().setCurrentProject(this.project, true);
		ProjectManager.getManager().getCurrentScene().update();
		SceneManager.instance.clean();
		return true;
	}
	
	@Override
	public void addPages() {
		this.project = ProjectManager.getManager().getCurrentProject();
		openPage = new OpenProjectPage(this.project);
		addPage(openPage);
	}
	
	@Override
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
	
}
