package dressing.ui;

import org.eclipse.jface.viewers.ITreeContentProvider;

import dressing.model.DesignObject3D;
import dressing.model.ProjectRoot;
import dressing.model.TreeElement;

public class ProjectTreeContentProvider implements ITreeContentProvider {
    @Override
    public boolean hasChildren(Object element) {
    	if(element!=null && element instanceof TreeElement) {
    		return ((TreeElement)element).hasChildren();
    	}else if (element!=null && element instanceof DesignObject3D) {
    		return ((DesignObject3D)element).getChilds().size()>0;
    	}
    	return false;
    }

    @Override
    public Object getParent(Object element) {
    	if(element!=null && element instanceof TreeElement) {
    		return ((TreeElement)element).getDirectParent();	
    	}else if(element instanceof DesignObject3D){
    		if(((DesignObject3D) element).getKitchen() != null)
				return	((DesignObject3D)element).getKitchen();
			return	((DesignObject3D)element).getParentdesign();
    	}
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
    	if(inputElement instanceof ProjectRoot)
    	{
    		Object[] o = ((TreeElement) inputElement).getChildren();
    		return o;
    	}
    	Object[] o = new Object[] {};
		return o;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
    	if(parentElement!=null && parentElement instanceof TreeElement)
    	{
    		return ((TreeElement)parentElement).getChildren();
    	}else if(parentElement instanceof DesignObject3D){
    		return ((DesignObject3D)parentElement).getChilds().toArray();
    	}
        return null;
    }
}