package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.Chant;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;

import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.NumericConvertor;

public class ChantEditorWindow extends EditorWindow {
	private Chant chant;
	private Chant chantOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtEp;
	private Text txtprice;

	public ChantEditorWindow(Shell parentShell,Chant chant,int update) {
		super(parentShell,update);	
		this.chant=chant;
		this.chantOrigin=EcoreUtil.copy(chant);
		setTitle("Editeur Chant");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Epaisseur");
		
		txtEp = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtEp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		Label lblPrice = new Label(clientArea, SWT.NONE);
		lblPrice.setText("Prix (DT/m)");
		txtprice = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtprice.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		parent.requestLayout();

		if(chant!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();
		double originEp = Double.valueOf(txtEp.getText().trim());

		this.chant.setName(originName);
		this.chant.setEpaisseur(originEp);
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getChants().getChant().add(chant);
		}
		ResourceManagers.getIntance().saveLibraryResource();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.chant.setName(this.chantOrigin.getName());
		this.chant.setEpaisseur(this.chantOrigin.getEpaisseur());
		this.chant.setPrice(this.chantOrigin.getPrice());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String ep=txtEp.getText();
		try {
			Double dep =Double.valueOf(ep);
			if(dep<=0) {
				errorExist=true;
				errorMessage="L'épaisseur doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="L'épaisseur est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = BeanProperties.value("name").observe(chant);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtEpObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtEp);
		IObservableValue epaisseurChantObserveValue = BeanProperties.value("epaisseur").observe(chant);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtEpObserveWidget, epaisseurChantObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtpriceObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtprice);
		IObservableValue priceChantObserveValue = BeanProperties.value("price").observe(chant);
		UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
		strategy_2.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
		strategy_3.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtpriceObserveWidget, priceChantObserveValue, strategy_2, strategy_3);
		//
		return bindingContext;
	}
}
