package dressing.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;

import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.svg.Box;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.MachineCodeHandler;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Rainure;
import dressing.cam.model.Trou;
import dressing.cam.model.Usinage;
import dressing.cam.model.Util;
import dressing.config.WorkspaceConfiguration;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.GenericDebitage;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesignElment;
import param.UsinageNode;

public class Piece2D extends DesignObject3D {

	private PieceType piecetype;
	private Material material;
	//Pour les pieces 2D
	private double epaisseur;
	private double pieceL;
	private double pieceH;
	transient private double positionetagere;
	private double longchant1;
	private double longchant2;
	private double longchant3;
	private double longchant4;
	private Chant chant1;
	private Chant chant2;
	private Chant chant3;
	private Chant chant4;
	private String chants="";
	private MechanicDesignElment mechanicDesignElementDefinition;
	private MaterialTypeInstance materialType;
	private MaterialTypeInstance vitreMaterialType;
	private int fichedebitNumber=1;
	private boolean solid=true;
	transient private String gcode;

	public String getChants() {
		return chants;
	}
	public void setChants(String chants) {
		String oldValue = this.chants;
		this.chants = chants;
		firePropertyChange("chants", oldValue, chants);
	}
	
	public double getLongchant1() {
		return longchant1;
	}
	public void setLongchant1(double longchant1) {
		double oldValue = this.longchant1;
		this.longchant1 = longchant1;
		firePropertyChange("longchant1", oldValue, longchant1);
	}
	public double getLongchant2() {
		return longchant2;
	}
	public void setLongchant2(double longchant2) {
		double oldValue = this.longchant2;
		this.longchant2 = longchant2;
		firePropertyChange("longchant2", oldValue, longchant2);
	}
	public double getLongchant3() {
		return longchant3;
	}
	public void setLongchant3(double longchant3) {
		double oldValue = this.longchant3;
		this.longchant3 = longchant3;
		firePropertyChange("longchant3", oldValue, longchant3);
	}
	public double getLongchant4() {
		return longchant4;
	}
	public void setLongchant4(double longchant4) {
		double oldValue = this.longchant4;
		this.longchant4 = longchant4;
		firePropertyChange("longchant4", oldValue, longchant4);
	}
	
	public MechanicDesignElment getMechanicDesignElementDefinition() {
		return mechanicDesignElementDefinition;
	}
	public void setMechanicDesignElementDefinition(MechanicDesignElment mechanicDesignElementDefinition) {
		Object old=this.mechanicDesignElementDefinition;				
		this.mechanicDesignElementDefinition = mechanicDesignElementDefinition;
		firePropertyChange("mechanicDesignElementDefinition", old, mechanicDesignElementDefinition);
	}
	
	public MaterialTypeInstance getMaterialType() {
		return materialType;
	}
	public void setMaterialType(MaterialTypeInstance materialType) {
		Object old=this.materialType;				
		this.materialType = materialType;
		firePropertyChange("materialType", old, materialType);
	}
	
	public MaterialTypeInstance getVitreMaterialType() {
		return vitreMaterialType;
	}
	public void setVitreMaterialType(MaterialTypeInstance vitreMaterialType) {
		Object old=this.vitreMaterialType;				
		this.vitreMaterialType = vitreMaterialType;
		firePropertyChange("vitreMaterialType", old, vitreMaterialType);
	}

	public Chant getChant1() {
		return chant1;
	}
	public void setChant1(Chant chant1) {
		Chant oldValue = this.chant1;
		this.chant1 = chant1;
		firePropertyChange("chant1", oldValue, chant1);
	}
	public Chant getChant2() {
		return chant2;
	}
	public void setChant2(Chant chant2) {
		Chant oldValue = this.chant2;
		this.chant2 = chant2;
		firePropertyChange("chant2", oldValue, chant2);
	}
	public Chant getChant3() {
		return chant3;
	}
	public void setChant3(Chant chant3) {
		Chant oldValue = this.chant3;
		this.chant3 = chant3;
		firePropertyChange("chant3", oldValue, chant3);
	}
	public Chant getChant4() {
		return chant4;
	}
	public void setChant4(Chant chant4) {
		Chant oldValue = this.chant4;
		this.chant4 = chant4;
		firePropertyChange("chant4", oldValue, chant4);
	}
	public void setPositionetagere(double positionetagere) {

		double oldValue = this.positionetagere;
		this.positionetagere = positionetagere;
		firePropertyChange("positionetagere", oldValue, positionetagere);
	}
	public double getPositionetagere() {
		return positionetagere;
	}
	public void setPieceH(double pieceH) {

		double oldValue = this.pieceH;
		this.pieceH = pieceH;
		firePropertyChange("pieceH", oldValue, pieceH);
	}
	public double getPieceL() {
		return pieceL;
	}
	public void setPieceL(double pieceL) {

		double oldValue = this.pieceL;
		this.pieceL = pieceL;
		firePropertyChange("pieceL", oldValue, pieceL);
	}
	public double getPieceH() {
		return pieceH;
	}
	public void setMaterial(Material material) {

		Material oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}
	public Material getMaterial() {
		return material;
	}

	public void setEpaisseur(double epaisseur) {

		double oldValue = this.epaisseur;
		this.epaisseur = epaisseur;
		firePropertyChange("epaisseur", oldValue, epaisseur);
	}
	public double getEpaisseur() {
		return epaisseur;
	}
	
	public boolean isSolid() {
		return solid;
	}
	public void setSolid(boolean solid) {
		this.solid = solid;
	}
	public void setPiecetype(PieceType droiteCuisson) {

		PieceType oldValue = this.piecetype;
		this.piecetype = droiteCuisson;
		firePropertyChange("piecetype", oldValue, droiteCuisson);
	}
	public PieceType getPiecetype() {
		return piecetype;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Accessoire || child instanceof Usinage || child instanceof Piece2D)
		{
			return true;
		}
		return false;
	}
	
	public String printDescription()
	{		
		String s="";
		s+=" 		Piece "  + getName() +"\n";
		s+=" 		Type "  + getPiecetype() +"\n";
		/*
		s+=" 		Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" 		Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" 		Profondeur extenre "  + getProfondeurext() +" mm \n";
		
		s+=" 		Longeur interne "  + getLongeurint() +" mm \n";
		s+=" 		Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" 		Profondeur interne "  + getProfondeurint() +" mm \n";
		*/
		s+=" 		L "  + getPieceL() +"  \n";
		s+=" 		H "  + getPieceH() +"  \n";
		s+=" 		Epaisseur"  + getEpaisseur() +"  \n";
		s+=" 		Matreieaux "  + getMaterial().getName() +"  \n\n";
		s+="		------Les sous elements ------\n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	public Piece2DCoupe createPieceCoupe()
	{
		Piece2DCoupe p = new Piece2DCoupe();
		p.setPieceH(getPieceH());
		p.setPieceL(getPieceL());
		p.setMaterial(getMaterial().getName());
		p.setChants(getChants());
		p.setQty(1);
		
		p.setPiecename(getName());
		
		if (getParentdesign() != null && getParentdesign() instanceof Caisson) {
			p.setParentname(getParentdesign().getName());
			p.setCaissonname(getParentdesign().getName());
		}
		
		if (getParentdesign() != null && getParentdesign() instanceof Project3D) {
			p.setParentname(getParentdesign().getName());
			p.setProjetname(getParentdesign().getName());
		}
			
		
		return p;
	}
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		
			String filename = "";
			if(getMaterial().getImage()!=null) {
				filename="pictures/"+getMaterial().getImage();
		}else {
			
			if(getPiecetype()==PieceType.BAS_CUISSON || getPiecetype()==PieceType.HAUT_CUISSON)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.GAUCHE_CUISSON ||  getPiecetype()==piecetype.DROITE_CUISSON)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.HAUT_CUISSON)
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.ETAGERE_MOBILE 
					|| getPiecetype()==piecetype.PORTE 
					||  getPiecetype()==piecetype.PORTE_DROITE
					||  getPiecetype()==piecetype.PORTE_HAUT)
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.ETAGERE_FIXE|| getPiecetype()==piecetype.PORTE_GAUCHE|| getPiecetype()==piecetype.PORTE_BAS )
			{
				filename="pictures/texture1.png";
			}	
			else if(getPiecetype()==piecetype.SEPRATEUR_TRANSVERSANT || getPiecetype()==piecetype.SEPRATEUR_NORMAL)
			{
				filename="pictures/texture1.png";
			}
			else if(getPiecetype()==piecetype.DOS_INTERIEUR ||getPiecetype()==piecetype.DOS_EXTERIRUR)
			{
				filename="pictures/back.jpg";
			}else if(getPiecetype()==piecetype.BAS_TIROIR) {
				filename="pictures/back.jpg";
			}else if(getPiecetype()==piecetype.COTE_DROITE_TIROIR || getPiecetype()==piecetype.COTE_GAUCHE_TIROIR)
			{
				filename="pictures/texture1.png";
			}else if(getPiecetype()==piecetype.DERIERE_TIROIR||getPiecetype()==piecetype.FACADE_EXTERIEUR_TIROIR||getPiecetype()==piecetype.FACADE_INTERIEUR_TIROIR)
			{
				filename="pictures/texture1.png";
			}else {
				filename="pictures/texture1.png";
			}
			
		}
			FileInputStream fis = null;
			BufferedImage bufferedImage = null;
			if(getMaterial().getName().contentEquals("generic")&& getMaterial().getImage()!=null && !getMaterial().getImage().isEmpty()) {
				try {
					bufferedImage = ModelProvider.getBufferedImagesHashMap().get(getMaterial().getImage());
					if(bufferedImage == null) {
						File file=new File(getMaterial().getImage());
						fis=new FileInputStream(file);
						bufferedImage =  ImageIO.read(fis);
						ModelProvider.getBufferedImagesHashMap().putIfAbsent(getMaterial().getImage(), bufferedImage);
					}
					
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}finally {
					if(fis != null)
						try {
							fis.close();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					return bufferedImage;
				}
			}else {
				
				try {
					bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
					if(bufferedImage == null) {
						File im= WorkspaceConfiguration.getimage(filename, true);
						if(im == null || !im.exists()) {
							filename = "pictures/royale-blanc-hanstone-slab.jpg";
							bufferedImage = ModelProvider.getBufferedImagesHashMap().get(filename);
							if(bufferedImage != null) {
								return bufferedImage;
							}
							im =  WorkspaceConfiguration.getimage(filename, true);
						}
						fis=new FileInputStream(im);
						bufferedImage =  ImageIO.read(fis);
						ModelProvider.getBufferedImagesHashMap().putIfAbsent(filename, bufferedImage);
						fis.close();
					}
					
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					if(fis != null)
						try {
							fis.close();
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					return bufferedImage;
				}
			}
	}
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
			return true;		
	}
	@Override
	public double gettransparency() {
		// TODO Auto-generated method stub
		 if(getPiecetype()==PieceType.PORTE || getPiecetype()==PieceType.PORTE_DROITE || getPiecetype()==PieceType.PORTE_GAUCHE
				 || getPiecetype()==PieceType.PORTE_HAUT || getPiecetype()==PieceType.PORTE_BAS)
		 {
			 return 0.1; 
		 }
		return 0;
	}
	@Override
	protected void updateMaterialFromParent(DesignObject3D parent) {
		// TODO Auto-generated method stub
		if(parent!=null)
		{
			if(!isBackmaterialfree())
			{
				setBackmaterial(parent.getBackmaterial());
			}
			if(!isBasematerialfree())
			{
				setBasematerial(parent.getBasematerial());
			}
			if(piecetype.equals(PieceType.DOS_EXTERIRUR) || piecetype.equals(PieceType.DOS_INTERIEUR))
			{
				setMaterial(parent.getBackmaterial());
			}
			else if(getPiecetype().equals(PieceType.PORTE)
					||getPiecetype().equals(PieceType.PORTE_DROITE)
					||getPiecetype().equals(PieceType.PORTE_GAUCHE)) {
				return;
			}
			else 
			{
				setMaterial(parent.getBasematerial());
			}
		}		
			
	}
	@Override
	protected void updateproperties() throws GeometricEngineException {
		// TODO Auto-generated method stub
		super.updateproperties();
		setNotificationon(false);
		Equation eq=null;
		try {
			if(debitage!=null)
			{
				eq  = Equation.FIND_EQUATION("@this.pieceL@", debitage.getEquations());
				if(eq!=null)
				{
					setPieceL(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceL@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.pieceH@", debitage.getEquations());
				if(eq!=null)
				{
					setPieceH(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pieceH@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.e@", debitage.getEquations());
				if(eq!=null)
				{
					setEpaisseur(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.e@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant1@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant1(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant1@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant2@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant2(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant2@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant3@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant3(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant3@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.chant4@", debitage.getEquations());
				if(eq!=null)
				{
					setLongchant4(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.chant4@ not found to update");
				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur1@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant1().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur1@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur2@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant2().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur2@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur3@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant3().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur3@ not found to update");
//				}
//				eq  = Equation.FIND_EQUATION("@this.epaisseur4@", debitage.getEquations());
//				if(eq!=null)
//				{
//					getChant4().setEpaisseur(eq.getEvaluation(null));
//				}
//				else
//				{
//					throw new GeometricEngineException("@this.epaisseur4@ not found to update");
//				}
				if(chant1!=null && chant2!=null && chant3!=null && chant4!=null) {
					convertwritablechantstest();
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		
	
	}
	public Map<String,String> generateElementsGcode() {
		if(getMaterialType()!=null &&getMaterialType().getMaterial()!=null
				&& getMaterialType().getMaterial().isProduction())
		{
			return MachineCodeHandler.getInstance().getGenerator().generateCode(this);
		}
		return null;
	}
	
	public void convertwritablechants()
	{
		double l1=0;
		double l2=0;
		String chant1="";
		String chant2="";
		//
		double ep1=getChant1().getEpaisseur();
		double ep2=getChant2().getEpaisseur();
		if(getChant1().getEpaisseur()==getChant2().getEpaisseur()||getChant2().getEpaisseur()==0) {
			if(getChant2().getEpaisseur()!=getChant3().getEpaisseur()&&getChant3().getEpaisseur()!=0) {
				ep2=getChant3().getEpaisseur();
			}else if(getChant2().getEpaisseur()!=getChant4().getEpaisseur()&&getChant4().getEpaisseur()!=0) {
				ep2=getChant4().getEpaisseur();
			}
		}
		if(ep1==0&& ep2==0) {
			return;
		}else if(ep1==0 && ep2!=0) {
			ep1=ep2;
		}else if(ep2==0 && ep1!=0) {
			ep2=ep1;
		}
		//
		String epaisseur1="";
		String epaisseur2="";
		//
		
		l1=getLongchant1();
		l2=getLongchant2();
		//
		if(l1>l2) {
			chant1="L";
			chant2="l";
		}else {
			chant1="l";
			chant2="L";
		}
		//
		
			if(getChant1().getEpaisseur()==getChant3().getEpaisseur()) {
				if(getChant1().getEpaisseur()==ep1) {
					epaisseur1="2"+chant1;
				}else if(getChant1().getEpaisseur()==ep2) {
					epaisseur2="2"+chant1;
				}
				
			}else {
				if(getChant1().getEpaisseur()==ep1) {
					epaisseur1="1"+chant1;
				}else if(getChant1().getEpaisseur()==ep2) {
					epaisseur2="1"+chant1;
				}
				if(getChant3().getEpaisseur()==ep1) {
					epaisseur1="1"+chant1;
				}else if(getChant3().getEpaisseur()==ep2) {
					epaisseur2="1"+chant1;
				}
			}
			//
			if(getChant2().getEpaisseur()==getChant4().getEpaisseur()) {
				if(getChant2().getEpaisseur()==ep1) {
					epaisseur1+="+2"+chant2;
				}else if(getChant2().getEpaisseur()==ep2) {
					epaisseur2+="+2"+chant2;
				}
				
			}else {
				if(getChant2().getEpaisseur()==ep1) {
					epaisseur1+="+1"+chant2;
				}else if(getChant2().getEpaisseur()==ep2) {
					epaisseur2+="+1"+chant2;
				}
				if(getChant4().getEpaisseur()==ep1) {
					epaisseur1+="+1"+chant2;
				}else if(getChant4().getEpaisseur()==ep2) {
					epaisseur2+="+1"+chant2;
				}
			}
		//
		if(!epaisseur1.isEmpty()) {
			epaisseur1=(int)ep1+"/10("+epaisseur1+")";
		}
		if(!epaisseur2.isEmpty()) {
			epaisseur2=(int)ep2+"/10("+epaisseur2+")";
		}
		//
		if(ep1>ep2) {
			setChants(epaisseur1+ " " +epaisseur2);
		}else {
			setChants(epaisseur2+epaisseur1);
		}
	
	}
	public void convertwritablechantstest()
	{
		double l1=0;
		double l2=0;
		String chant1="";
		String chant2="";
		//
		l1=getLongchant1();
		l2=getLongchant2();
		//
		if(l1>l2) {
			chant1="L";
			chant2="l";
		}else {
			chant1="l";
			chant2="L";
		}
		//
		chants="";
		for(Chant chnt: ModelProvider.getListChant()) {
			String chntChants="";
			String chntChants1="";
			if(getChant1().equals(getChant3()) ) {
				if(getChant1().equals(chnt)) {
					chntChants1="2"+chant1;
				}
				
			}else {
				if(getChant1().equals(chnt)) {
					chntChants1="1"+chant1;
				}
				if(getChant3().equals(chnt)) {
					chntChants1="1"+chant1;
				}
			}
			
			String chntChants2="";
			if(getChant2().equals(getChant4()) ) {
				if(getChant2().equals(chnt)) {
					chntChants2="2"+chant2;
				}
				
			}else {
				if(getChant2().equals(chnt)) {
					chntChants2="1"+chant2;
				}
				if(getChant4().equals(chnt)) {
					chntChants2="1"+chant2;
				}
			}
			//
			if(!chntChants1.isEmpty()&& !chntChants2.isEmpty()) {
				chntChants=chnt.getName()+"("+chntChants1+"+"+chntChants2 +")";
			}else {
				if(!chntChants1.isEmpty()&& chntChants2.isEmpty() ) {
					chntChants=chnt.getName()+"("+chntChants1 +")";
				}else if(!chntChants2.isEmpty()&& chntChants1.isEmpty() ){
					chntChants=chnt.getName()+"("+chntChants2 +")";

				}
			}
			
			//
			if(!chntChants.isEmpty()) {
				chants+=chntChants+" ";
			}
		}
	
	}
	/***
	 * Cette methode retourne le point par rapport au repore 2D
	 * @return
	 */
	public Point3D getConvertedPointIn2D(PlanUsinage persp)
	{
		Point3D p = new Point3D();
		switch (persp) {
		case FRONT:
			p.x = this.getXPosABS();
			p.y = - this.getYPosABS() - this.getHauteurext();
			p.z=0;
			break;

		default:
			
			break;
		}
		return p; 
		
		
	}
	
	@Override
	public void createUsinage(List<Usinage> usins, boolean cavityOnly) throws GeometricEngineException, DesignException {
//		MechanicDesignCreator.checkPieceIntersectionWithObstacles(getRoot(), this);
		if( getMechanicDesignDefinition()!=null&& getMechanicDesignElementDefinition()!=null) {
			
			if(getMechanicDesignElementDefinition().getUsinagenode()!=null) {
		
				for(UsinageNode node:getMechanicDesignElementDefinition().getUsinagenode()) {
					boolean nodeexist=true;
					if(node.getExistexpression()!=null && !node.getExistexpression().isEmpty()) {
						ArrayList<Equation> equations = new ArrayList<Equation>();
						Usinage designNode=new Usinage();
						GenericDebitage.createupdateDebitage(this,designNode,getMechanicDesignDefinition().getPrivateparamgroup().getMechanicprivateparam(),getMechanicDesignDefinition().getPublicparamgroup().getMechanicpublicparam(),node,equations);
						nodeexist=(Boolean) designNode.get("EXIST");
					}
					if (nodeexist) {
						MechanicDesignCreator.getInstance().buildUsinageNode(this, node,usins,cavityOnly);
					}
				}
			}
			//créer usinage depuis systeme d'assemlage
			if(!cavityOnly)
			{
//				MechanicDesignCreator.getInstance().createDynamicAssemblySystem(this,usins, cavityOnly);
			}
		}
		super.createUsinage(usins,cavityOnly);
//		clearParts();
	}
	@Override
	public void deleteUsinage() throws Exception {
		List<DesignObject3D>childstobeDeleted =new ArrayList<DesignObject3D>();		
		//collecter les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:getChilds()) {
			
			if((design instanceof Usinage)|| (design instanceof Accessoire)) {
				childstobeDeleted.add(design);
			}
		}
				
		//supprimer tout les usinage qui référence sur cette piece comme parent 	
		for(DesignObject3D design:childstobeDeleted) {	
			
			deletechild(design,true);
		}
//		clearFaces();
		
		super.deleteUsinage();
	}
	
	public DesignObject3D getRootCaisson() {
		DesignObject3D parent= this.getParentdesign();
		while(parent!= null && !(parent instanceof Caisson) && !(parent instanceof Space3DFree)) {
			parent=parent.getParentdesign();
		}
		return parent;
		
	}
	public List<Piece2D> gettangentedPieces(Piece2D piece,DesignObject3D frere) {
		 List<Piece2D> tangentedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D ) {
				tangentedPiece.addAll(gettangentedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D) {
				if(piece.isIntersect(child).equals(IntersectionType.TANGENT)) {
					tangentedPiece.add((Piece2D) child);
				}
			}
		}
		return tangentedPiece;
		
	}
	
	public List<Piece2D> getIntersectedPieces(Piece2D piece,DesignObject3D frere) {
		 List<Piece2D> intesectedPiece=new ArrayList<Piece2D>();
		for(DesignObject3D child:frere.getChilds()) {
			if(child instanceof Space3D ) {
				intesectedPiece.addAll(getIntersectedPieces(piece, child)) ;
			}
			if(child instanceof Piece2D && !piece.equals(child)) {
				if(piece.isIntersect(child).equals(IntersectionType.INTERSECTION)) {
					intesectedPiece.add((Piece2D) child);
				}
			}
		}
		return intesectedPiece;
		
	}

	/**
	 * Tester si cette piece est parellle de point de vue X
	 * c est a dire qui il sont tous les deux verticlae entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	/**
	 * Tester si deux piece verticale on des y paratgé
	 * @param sld2
	 * @return
	 */
	public boolean isShareAccordingtoY(Piece2D sld2) {
		if(this.isVerticallPiece() && sld2.isVerticallPiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getYinter()!=null && !intersection.getYinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}
	
	public ArrayList<Vector3> getCornersList(){
		ArrayList<Vector3> corners = new ArrayList<Vector3>();
		Vector3 origin000 = new Vector3(0,0,0);
		Vector3 origin001 = new Vector3(0,0,(float) getProfondeurext());
		Vector3 origin010 = new Vector3(0,(float) getHauteurext(),0);
		Vector3 origin011 = new Vector3(0,(float) getHauteurext(),(float) getProfondeurext());
		Vector3 origin100 = new Vector3((float) getLongeurext(),0,0);
		Vector3 origin101 = new Vector3((float) getLongeurext(),0,(float) getProfondeurext());
		Vector3 origin110 = new Vector3((float) getLongeurext(),(float) getHauteurext(),0);
		Vector3 origin111 = new Vector3((float) getLongeurext(),(float) getHauteurext(),(float) getProfondeurext());
		corners.add(origin000);
		corners.add(origin001);
		corners.add(origin010);
		corners.add(origin011);
		corners.add(origin100);
		corners.add(origin101);
		corners.add(origin110);
		corners.add(origin111);
		return corners;
	}
	
	/**
	 * Tester si cette piece est parellle de point de vue y
	 * c est a dire qui il sont tous les deux horizontale entre eux
	 * @param sld2 la deuxieme pièce
	 * @return
	 */
	public boolean isParallelAccordingtoY(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			//deux pieces horizontales on teste si les y se chauvecheement
			return this.isIntersect(sld2).equals(IntersectionType.NOT_RELATED);
			
		}
		return false;
	}
	public boolean isShareAccordingtoX(Piece2D sld2) {
		// TODO Auto-generated method stub
		if(this.isHorizontalePiece() && sld2.isHorizontalePiece())
		{
			Plan3D plan1=new Plan3D(this);
			Plan3D plan2=new Plan3D(sld2);
			Plan3D intersection=plan1.getIntersection(plan2);
			if(intersection.getXinter()!=null && !intersection.getXinter().isPoint())
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le X
	 * Comme les cote et les seprateurs verticlae
	 */
	public boolean isVerticallPiece()
	{
		return this.getLongeurext()<this.getHauteurext() && this.getLongeurext()<this.getProfondeurext();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Y
	 * Comme les les etageres
	 */
	public boolean isHorizontalePiece()
	{
		return this.getHauteurext()<this.getLongeurext() && this.getHauteurext()<this.getProfondeurext();
	}
	/**
	 * Si cette piece est verticale lorsque la plus faible cote est dans le Z
	 * Comme le dos
	 */
	public boolean isProfondPiece()
	{
		return this.getProfondeurext()<this.getLongeurext() && this.getProfondeurext()<this.getHauteurext();
	}
	
	public  Orientation getPieceOrientation() {
		if (isHorizontalePiece()) {
			return Orientation.HORIZONTAL;
		} else if (isProfondPiece()) {
			return Orientation.PROUFOUND;
		} else {
			return Orientation.VERTICAL;
		}
	}
	public PlanUsinage getPrimaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			return PlanUsinage.TOP;
		case PROUFOUND:
			return PlanUsinage.FRONT;
			
		case VERTICAL:
			return PlanUsinage.RIGHT;
			
		default:
			return PlanUsinage.FRONT;
		}
	}
	public PlanUsinage getSecondaryPrespective() {
		Orientation orient = getPieceOrientation();
		switch (orient) {
		case HORIZONTAL:
			
			return PlanUsinage.DOWN;
			
		case PROUFOUND:
			
			return PlanUsinage.BACK;
		case VERTICAL:
			return PlanUsinage.LEFT;

		default:
			return PlanUsinage.BACK;
		}
	}
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return "Piece  "+getName()+"[posx=" + xpos + ", posy=" + ypos + ", posz=" + zpos + ", longeur=" + getLongeurext()
				+ ", hauteur=" + getHauteurext() + ", profondeur=" + getProfondeurext()  + "]";
	}

	@Override
	public DesignObject3D clone() {
		Piece2D space=new Piece2D();
		try {
			space=(Piece2D) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Piece2D piece=(Piece2D) object;
		 piece.setLongeurext(getLongeurext());
		 piece.setLongeurextfree(isLongeurextfree());
		 piece.setProfondeurext(getProfondeurext());
		 piece.setProfondeurextfree(isProfondeurextfree());
		 piece.setHauteurext(getHauteurext());
		 piece.setHauteurextfree(isHauteurextfree());
		 piece.setLongeurint(getLongeurint());
		 piece.setProfondeurint(getProfondeurint());
		 piece.setHauteurint(getHauteurint());
		 piece.setName(getName());
		 piece.setBasematerial(getBasematerial());
		 piece.setBasematerialfree(isBasematerialfree());
		 piece.setBackmaterial(getBackmaterial());
		 piece.setBackmaterialfree(isBackmaterialfree());
		 piece.setFacadeMaterial(getFacadeMaterial());
		 piece.setFacadematerialfree(isFacadematerialfree());
		 piece.setXpos(getXpos());
		 piece.setYpos(getYpos());
		 piece.setZpos(getZpos());
		 piece.setXPosABS(getXPosABS());
		 piece.setYPosABS(getYPosABS());
		 piece.setZPosABS(getZPosABS());		 
		piece.setPiecetype(getPiecetype());
		piece.setMaterial(getMaterial());
		piece.setEpaisseur(getEpaisseur());
		piece.setPieceL(getPieceL());
		piece.setPieceH(getPieceH());
		piece.setPositionetagere(getPositionetagere());
		piece.setLongchant1(getLongchant1());
		piece.setLongchant2(getLongchant2());
		piece.setLongchant3(getLongchant3());
		piece.setLongchant4(getLongchant4());
		piece.setChant1(getChant1());
		piece.setChant2(getChant2());
		piece.setChant3(getChant3());
		piece.setChant4(getChant4());
		piece.setChants(getChants());
		piece.setProps(getProps());
		piece.systemesequations=this.systemesequations;
		piece.systemesequationsasparent=this.systemesequationsasparent;
		piece.setID(getID());
		for(DesignObject3D design:getChilds() ) {
				DesignObject3D copy= design.clone();
				 piece.addElement(copy);	
		 }		
		return piece;
	}	
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		
		if(formulas==null|| !(formulas instanceof DebitageFormulas)) {
			formulas = new DebitageFormulas();
		}
		return formulas; 
	}
	@Override
	public ArrayList<Couple> getSystemEquationAsParent() {
		// TODO Auto-generated method stub
		systemesequationsasparent.clear();
		systemesequationsasparent.add(new Couple("@Parent.l@", ""+getLongeurext()));
		systemesequationsasparent.add(new Couple("@Parent.p@", ""+getProfondeurext()));
		systemesequationsasparent.add(new Couple("@Parent.h@", ""+getHauteurext()));
		systemesequationsasparent.add(new Couple("@Parent.li@", ""+getLongeurint()));
		systemesequationsasparent.add(new Couple("@Parent.pi@", ""+getProfondeurint()));
		systemesequationsasparent.add(new Couple("@Parent.hi@", ""+getHauteurint()));
		
		systemesequationsasparent.add(new Couple("@Parent.epaisseursecondaire@", ""+getBackmaterial().getEpaisseur()));
		systemesequationsasparent.add(new Couple("@Parent.epaisseurprincipale@", ""+getBasematerial().getEpaisseur()));

		systemesequationsasparent.add(new Couple("@Parent.posx@", ""+getXpos()));
		systemesequationsasparent.add(new Couple("@Parent.posy@", ""+getYpos()));
		systemesequationsasparent.add(new Couple("@Parent.posz@", ""+getZpos()));
		

		return systemesequationsasparent;
 	}
	public boolean isFacade() {
		if(this.piecetype== PieceType.PORTE || this.piecetype == PieceType.PORTE_GAUCHE  
			|| this.piecetype == PieceType.PORTE_DROITE || this.piecetype == PieceType.PORTE_BAS 
			|| this.piecetype == PieceType.PORTE_HAUT|| this.piecetype == PieceType.FACADE) {
			return true;
		}
		return false;
	}
	public List<Usinage> getusinage(){
		List<Usinage> usins=new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Usinage) {
				usins.add((Usinage) design);
			}
		}
		return usins;
	}
	public List<Trou> getTrous(){
		List<Trou> trous = new ArrayList<Trou>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Trou) {
				trous.add((Trou) design);
			}
		}
		return trous;
	}
	
	public List<Usinage> getCavities(){
		List<Usinage> rainures = new ArrayList<Usinage>();
		for(DesignObject3D design:getChilds()) {
			if(!(design instanceof Trou)) {
				rainures.add((Usinage) design);
			}
		}
		return rainures;
	}
	public List<Cavity> getPiecesCavities(){
		List<Cavity> rainures = new ArrayList<Cavity>();
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Cavity) {
				rainures.add((Cavity) design);
			}
		}
		return rainures;
	}
		

	
	public int getFichedebitNumber() {
		return fichedebitNumber;
	}
	public void setFichedebitNumber(int fichedebitNumber) {
		this.fichedebitNumber = fichedebitNumber;
	}
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
		piecetype = null;
		material = null;
		chant1 = null;
		chant2 = null;
		chant3 = null;
		chant4 = null;
		chants = null;
		if (mechanicDesignElementDefinition != null)
			mechanicDesignElementDefinition.dispose();

		if (materialType != null)
			materialType.dispose();
		
		if (vitreMaterialType != null)
			materialType.dispose();
		
		mechanicDesignElementDefinition=null;
		materialType = null;
		vitreMaterialType = null;
	}

		
		public Box toSVGBox() {
			Box box =  new Box(getPosition().add(getSize().scl(0.5f)), getSize());
			Vector3 color = new Vector3();
			if(getPiecetype().isBack()) {
				color.set(226,187,123).scl(1.0f/255.0f);
			}else {
				color.set(164,116,73).scl(1.0f/255.0f);
			}
			box.setColor(color);
			return box;
		}
		public float getSurface(PlanUsinage face) {
			return (float) (Util.getPieceL(this,face) * Util.getPieceH(this, face));
		}
//		public void setChilds(ArrayList<Usinage> listExtrusion) {
//			// TODO Auto-generated method stub
//			
//		}
		public Vector3 getCenter() {
			Vector3 halfSize = getSize().scl(0.5f);
			return getPosition().add(halfSize);
		}
		public List<Rainure> getPiecesRainures(){
			List<Rainure> rainures = new ArrayList<Rainure>();
			for(DesignObject3D design:getChilds()) {
				if(design instanceof Rainure) {
					rainures.add((Rainure) design);
				}
			}
			return rainures;
		}
		public double getWidth(PlanUsinage face) {
			
			return Util.getDesignWidth(this, face);
			
		}
		public double getHight(PlanUsinage face) {
			// TODO Auto-generated method stub
			return Util.getDesignHeight(this, face);
		}
}
