package gdxapp.scenes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import org.eclipse.e4.ui.workbench.modeling.ESelectionService;


import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.mathutils.Edge;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.ProjectManager;
import dressing.model.Space3D;
import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.dpos.SceneDPO;
import dressing.model.persistence.mappers.Persistable;
import dressing.ui.ChangeCommand;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.SurfaceScreen;
import gdxapp.screens.wall.WallFragment;
import gdxapp.ui.Note;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.Measure;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.quotation.Quotation.QuotationDisplayMode;

@Persistable(persistableForm = SceneDPO.class)
public class Scene implements PropertyChangeListener, EventHandler
{
	
	public static Game game;
    private ScenePreferences preferences;
	private transient ArrayList<WorldObject> sceneObjects = new ArrayList<WorldObject>();
	private ArrayList<Object3D> objects = new ArrayList<Object3D>();
	private transient ArrayList<Note> notes = new ArrayList<Note>();
	private ArrayList<Measure> measures = new ArrayList<Measure>();
	private HashMap<Edge,WallFragment> fragments;

	//the constraint hashmap key represents the worldobject playing the world of the constraint, the vector3 is the position
	// of the center of the constraint in real world cs 
	private HashMap<WorldObject,Vector3> constraints =  new HashMap<WorldObject, Vector3>();
	private HashMap<WorldObject,Vector3> doors =  new HashMap<WorldObject, Vector3>();
	private  ArrayList<Fleche> fleches = new ArrayList<Fleche>();
    private transient  Array<SurfaceScreen> surfaceScreens = new Array<SurfaceScreen>();
	public transient ArrayList<Object2D> hiddenElements = new ArrayList<Object2D>();
	public transient boolean requireRefresh;
    public transient boolean isNew;
    public transient boolean updateWorldObjectPosition = false;
    transient WorldObject selectedActor=null;
    transient ESelectionService selectionService;
    public transient CommandStack stack;
    public transient RotateCommand rotate;
    public transient ScaleCommand scale;
    public transient MoveCommand move;
    
    private QuotationDisplayMode quotationMode;
    
    public Scene(){
    	sceneObjects = new ArrayList<WorldObject>();
    	objects = new ArrayList<Object3D>();
    	notes = new ArrayList<Note>();
    	measures = new ArrayList<Measure>();
    	fragments = new HashMap<Edge, WallFragment>();
    	constraints =  new HashMap<WorldObject, Vector3>();
    	doors =  new HashMap<WorldObject, Vector3>();
    	fleches = new ArrayList<Fleche>();
        surfaceScreens = new Array<SurfaceScreen>();
    	hiddenElements = new ArrayList<Object2D>();    	
        preferences = new ScenePreferences();
        preferences.addPropertyChangeListener(this);
        isNew = true;
		subscriveToEvents();
		SceneManager.instance.addSceneInstance(this);
    }
    
    public void setSelectionService(ESelectionService selectionService) {
		this.selectionService = selectionService;
	}
    public  void addActor(WorldObject actor, boolean update){
    	if(sceneObjects == null)
    		sceneObjects = new ArrayList<WorldObject>();
        sceneObjects.add(actor);
		actor.setSceneId(UUID.randomUUID());
		if(actor instanceof KitchenElement) {
			KitchenElement element = (KitchenElement) actor;
			if(ProjectManager.getManager().getCurrentKitchen().getElement(element.getUuid()) == null) {
				try {
					ProjectManager.getManager().getCurrentKitchen().addElement(element.getDesignObject());
				} catch (DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					sceneObjects.remove(actor);
				}
			}
				
		}
		
        if(update)
        	update();
    }
    public void clear() {
    	if(sceneObjects != null)
    		sceneObjects.clear();
        if(notes!=null)
        	notes.clear();
        if(constraints != null)
        	constraints.clear();
        if(fragments != null)
        	fragments.clear();
    }
    public  SurfaceScreen getWallScreen(Surface surface){
        if(getSurfaceScreens().size>0){
            for(SurfaceScreen surfaceScreen: getSurfaceScreens()){
                if(((SurfaceController)surfaceScreen.getController()).getSurface() == surface)
                    return  surfaceScreen;
            }
        }
        return null;
    }
    
	public WorldObject getSelectedobject() {
	
		return selectedActor;
	}
	


	public ArrayList<Wall> getWalls(){
		ArrayList<Wall> walls=new ArrayList<Wall>();
		for(int i=0;i<sceneObjects.size();i++ ) {
			WorldObject object=sceneObjects.get(i);
			if(object instanceof Wall) {
				walls.add((Wall) object);
			}
		}
		
		return walls;
	}
	
	public ArrayList<WorldObject> getWorldObjectsByType(ObjectType type){
		ArrayList<WorldObject> objects = new ArrayList<WorldObject>();
		for(WorldObject wObject : sceneObjects) {
			if(wObject.getType().equals(type))
				objects.add(wObject);
		}
		return objects;
	}
	
	public ArrayList<KitchenElement> getKitchenElements(){
		ArrayList<KitchenElement> elements = new ArrayList<KitchenElement>();
		for(WorldObject wObject : sceneObjects) {
			if(wObject instanceof KitchenElement)
				elements.add((KitchenElement) wObject);
		}
		return elements;
	}
	public KitchenElement getKitchenElement(DesignObject3D design){

		for(WorldObject wObject : sceneObjects) {
			if(wObject instanceof KitchenElement element && element.getDesignObject()!=null && element.getDesignObject().equals(design)) {
				return (KitchenElement) wObject;
			}
		}
		return null;
	}
	public ArrayList<KitchenElement> getWorldObjectsByFamilyType(int family){
		ArrayList<KitchenElement> filteredList = new ArrayList<KitchenElement>();
		for(KitchenElement element : getKitchenElements()) {
			if(WorldObjectFactory.getDesignFamily(element) == family) {
				filteredList.add(element);
			}
		}
		return filteredList;
		
	}
	
	
	public boolean isNew() {
		return isNew;
	}

	public void setNew(boolean isNew) {
		this.isNew = isNew;
	}

	public ArrayList<Object3D> getObjects() {
		return objects;
	}

	public void setObjects(ArrayList<Object3D> objects) {
		this.objects.clear();
		this.objects.addAll(objects);
	}

	public ArrayList<WorldObject> getSceneObjects() {
		return sceneObjects;
	}

	public void setSceneObjects(ArrayList<WorldObject> sceneObjects) {
		if(this.sceneObjects == null)
			this.sceneObjects = new ArrayList();
		this.sceneObjects.clear();
		if(sceneObjects != null)
			this.sceneObjects.addAll(sceneObjects);
	}


	public void removeWorldObject(Object wObject) {
		WorldObject object = null;
		if(wObject instanceof WorldObject) {
			object = (WorldObject) wObject;
		}else if(wObject instanceof Object2D) {
			object = ((Object2D) wObject).getWorldObject();
		}
		if(object != null) {
			GroupSelection.getInstance().clearSelection();
			this.sceneObjects.remove(object);
			if(object instanceof KitchenElement && ProjectManager.instance.getCurrentKitchen()!=null) {
				ProjectManager.instance.getCurrentKitchen().removeElement((Space3D) ((KitchenElement) object).getDesignObject());
			}else if(object instanceof Wall) {
				Wall wall = (Wall) object;
				ArrayList<Edge> wallFragms = new ArrayList<Edge>();
				for(Edge edge:fragments.keySet()) {
					if(wall.getPerimeter().getEdges().contains(edge))
						wallFragms.add(edge);
				}
				for(Edge edgeToRemove: wallFragms) {
					this.fragments.remove(edgeToRemove);
				}
				sceneObjects.remove(object);
			}
			removeConstraint(object);
		}		
	}
	
	public void setSelection(WorldObject object) {
		try {
			if(object.equals(selectedActor)) {
				return;
			}
			if(selectedActor!=null)
			{
				selectedActor.setSelected(false);
				List<ChangeCommand> stack=new ArrayList<ChangeCommand>();
				if(rotate!=null && selectedActor.equals(rotate.getTarget())) {
					float newRotation =object.getRotation();
					rotate.setNewRotation(newRotation);
					if(rotate.getOldRotation()!=newRotation) {
						stack.add(rotate);	
					}
				}
				if(move!=null  && selectedActor.equals(move.getTarget())) {
					Vector3 newPosition=object.getRealWorldPosition();
					move.setNewPosition(newPosition);
					if(!move.getOldPosition().epsilonEquals(newPosition))
					{
						stack.add(move);
					}
				}
				if(scale!=null && object instanceof KitchenElement && selectedActor.equals(scale.getTarget())) {
					Vector4 newDimension=((KitchenElement) object).getObjectDimention();
					scale.setNewDimension(newDimension);
					if(!scale.getOldDimension().epsilonEquals(newDimension, 0.00001f))
					{
						stack.add(scale);	
					}
				}
				if(stack!=null && stack.size()>0  && selectedActor.equals(rotate.getTarget()))
				{
					this.stack=new CommandStack("stack","stack", stack);
//					ChangeCommandController.getInstance().addCommand(this.stack);
				}
				
				
			}
			if(sceneObjects.contains(object)) {
				object.setSelected(true);
				selectedActor=object;
				//
				if(selectedActor!=null) {
					float oldRotation = object.getRotation();
					Vector3 oldPosition = object.getRealWorldPosition();
					Vector4 oldDimention = ((KitchenElement) object).getObjectDimention();
					rotate =new RotateCommand("rotate"+selectedActor.getName(), "rotate", selectedActor, oldRotation, oldRotation);
					move =new MoveCommand("move"+selectedActor.getName(), "move",  oldPosition, oldPosition,selectedActor);
					scale= new ScaleCommand("move"+selectedActor.getName(), "move",  oldDimention, oldDimention,selectedActor);
				}
				
				
			}
			
			
		}catch(Exception e) {
			e.printStackTrace();
			
		}
	}

	public QuotationDisplayMode getQuotationMode() {
		return quotationMode;
	}

	public void setQuotationMode(QuotationDisplayMode quotationMode) {
		this.quotationMode = quotationMode;
	}

	public Array<SurfaceScreen> getSurfaceScreens() {
		if(surfaceScreens==null) {
			surfaceScreens=new Array<SurfaceScreen>();
		}
		return surfaceScreens;
	}

	public void setSurfaceScreens(Array<SurfaceScreen> surfaceScreens) {
		this.surfaceScreens = surfaceScreens;
	}

	public ScenePreferences getPreferences() {
		if(preferences==null) {
			preferences=new ScenePreferences();
		}
		return preferences;
	}

	public void setPreferences(ScenePreferences preferences) {
		//dispose of the old preferences
		if(this.preferences !=null)
			this.preferences.dispose();
		this.preferences = preferences;
		this.preferences.addPropertyChangeListener(this);
	}

	public ArrayList<Note> getNotes() {
		if(notes == null) 
			notes = new ArrayList<Note>();
		return notes;
	}

	public void setNotes(ArrayList<Note> notes) {
		this.notes = notes;
	}

	public void hide(WorldObject worldObject) {
		worldObject.setHidden(true);	
	}
	
	public void unhide(WorldObject worldObject) {
		worldObject.setHidden(false);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.SHOW_OBJECT.name(), worldObject));
	}
	
	public void unhideObjects() {			
		for(WorldObject worldObject: sceneObjects) {
			unhide(worldObject);
		}
	}
	
	public void update() {
		try {
			 Gdx.app.postRunnable(() ->((AbstractScreen) game.getScreen()).getController().reloadActors());
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void updateObject2D(WorldObject worldObject) {
		try {
			((AbstractScreen) game.getScreen()).getController().reloadActors();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void addNote(Note note) {
		if(note!=null) {
			getNotes().add(note);
			update();
		}
	}
	public void removeNote(Note note) {
		if(note!=null) {
			note.remove();
			getNotes().remove(note);
			update();
		}
		
	}


	public ArrayList<Measure> getMeasures() {
		if(measures==null) {
			measures = new ArrayList<Measure>();
		}
		return measures;
	}
	public void removeMeasure(Measure measure) {
		measure.getLineSegment().clear();
		measure.getLineSegment().remove();
		getMeasures().remove(measure);
		update();
	}
	public void addMeasure(Measure measure) {
		getMeasures().add(measure);
		update();
	}
	public void setMeasures(ArrayList<Measure> measures) {
		if(measures != null)
			this.measures = measures;
	}

	public ArrayList<Fleche> getFleches() {
		if(fleches==null) {
			fleches = new ArrayList<Fleche>();
		}
		return fleches;
	}

	public void setFleches(ArrayList<Fleche> fleches) {
		this.fleches = fleches;
	}
	public void removeFleche(Fleche fleche) {
		fleche.getFlecheSegment().clear();
		fleche.getFlecheSegment().remove();
		getFleches().remove(fleche);
		update();
	}
	public void addFleche(Fleche fleche) {
		getFleches().add(fleche);
		update();
	}

	
	public ArrayList<KitchenElement> getWorldObjectByModelUUID(UUID uuid) {
		ArrayList<KitchenElement> objects = new ArrayList<KitchenElement>();
		for(KitchenElement object: getKitchenElements()) {
			if(object.getMechanicDesign() != null && object.getMechanicDesign().getModelId() != null &&
					object.getMechanicDesign().getModelId().equals(uuid)) {
				objects.add(object);
			}
		}
		return objects;
	}

	public WorldObject getWorldObjectByName(String name) {
		for(WorldObject worldObject: sceneObjects) {
			if(worldObject.getName() != null && worldObject.getName().equals(name))
				return worldObject;
		}
		return null;
	}
	
	public void addConstraint(WorldObject worldObject, Vector3 center) {
		this.constraints.put(worldObject ,center);
		for(Wall wall: getWalls()) {
			wall.setRequireRefrech(true);
		}
	}
	
	public void addDoor(WorldObject door, Vector3 position) {
		this.doors.put(door, position);
		for(Wall wall: getWalls()) {
			wall.setRequireRefrech(true);
		}
	}

	public HashMap<WorldObject, Vector3> getConstraints() {
		return constraints;
	}

	public void setConstraints(HashMap<WorldObject, Vector3> constraints) {
		if(constraints != null)
			this.constraints = constraints;
	}

	public HashMap<WorldObject, Vector3> getDoors() {
		return doors;
	}

	public void setDoors(HashMap<WorldObject, Vector3> doors) {
		if(doors != null)
			this.doors = doors;
	}

	public float[] getConstraints(Edge edge, Matrix4 transform) {
		if(constraints ==null)
			return null;
		float[] constraint = null;
		WorldObject constraintObject = null;
		Vector3 center = null;
		for(WorldObject key: constraints.keySet()) {
			var cnstrnt = constraints.get(key);
			if(cnstrnt != null) {
				center = cnstrnt.cpy().mul(transform.cpy().inv());
				if(edge.contains(new Vector2(center.x, center.y))) {
					constraintObject = key;
					break;
				}
			}
			
		}
		if(constraintObject != null) {
			//Vector3 position = doors.get(constraintDoor);
			constraint = new float[] {center.x, center.y, center.z, constraintObject.getRealWorldDimension().x -0.1f,
					constraintObject.getRealWorldDimension().y};
			
		}
		return constraint;
	}

	public float[] getDoors(Edge edge, Matrix4 transform) {
		if(doors == null)
			return null;
		float[] constraint = null;
		WorldObject constraintDoor = null;
		Vector3 center = null;
		for(WorldObject door: doors.keySet()) {
			center = doors.get(door).cpy().mul(transform.cpy().inv());
			if(edge.contains(new Vector2(center.x, center.y))) {
				constraintDoor = door;
				break;
			}
		}
		if(constraintDoor != null) {
			//Vector3 position = doors.get(constraintDoor);
			constraint = new float[] {center.x, center.y, constraintDoor.getRealWorldDimension().x,
					constraintDoor.getRealWorldDimension().y};
			
		}
		return constraint;
	}

	public void removeConstraint(WorldObject worldObject) {
		this.constraints.remove(worldObject);
		this.doors.remove(worldObject);
		for(Wall wall: getWalls()) {
			wall.setRequireRefrech(true);
		}
	}
	
	public  void insertWallFragment(Edge edge, float height, float thickness, Material material) {
		if(fragments == null) {
			fragments = new HashMap<Edge, WallFragment>();
		}
		WallFragment wallFragment = new WallFragment();
		wallFragment.setHeight(height);
		wallFragment.setThickness(thickness);
		wallFragment.setMaterial(material);
		fragments.put(edge, wallFragment);
	}
	
	public  HashMap<Edge, WallFragment> getFragments(){
		if(fragments == null)
			fragments = new HashMap<Edge, WallFragment>();
		return fragments;
	}
	
	

	public void setFragments(HashMap<Edge, WallFragment> fragments) {
		if(fragments != null)
			this.fragments = fragments;
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		System.err.println("scene preferences changed");
		
	}

	public void initAfterRead() {
		this.preferences.initAfterRead();
		this.preferences.addPropertyChangeListener(this);
		subscriveToEvents();
	}

	
	
	void subscriveToEvents() {
		subscribe(SceneEvent.WALL_MATERIAL_CHANGED.name(),
				SceneEvent.HANDLER_CHANGED.name(),
				SceneEvent.REMOVE_OBJECT_REQUEST.name(),
				SceneEvent.COPY.name(),
				SceneEvent.UNHIDE_ALL.name());
	}

	@Override
	public void handle(Event event) {
		SceneEvent EVENT = SceneEvent.valueOf(event.getTopic());
		switch(EVENT) {
		case WALL_MATERIAL_CHANGED:
			wallMtlChanged();
			break;
		case UNHIDE_ALL:
			unhideObjects();
			break;
		case HANDLER_CHANGED:
			handlerChanged();
			break;
		case REMOVE_OBJECT_REQUEST:
			removeWorldObject(event.getData());
			break;
		case COPY:
			past(event);
			break;
		}		
	}
	
	private void past(Event event) {
		HashMap<String, Object> map = (HashMap<String, Object>) event.getData();
		WorldObject copy = (WorldObject) map.get("element");
		Vector3 location = (Vector3) map.get("position");
		copy.setRealWorldPosition(location);
		addActor(copy, true);
	}

	private void wallMtlChanged() {
		for(Wall wall: getWalls()) {
			wall.setMaterial(preferences.getWallMtl());
		}
	}

	private void handlerChanged() {
		for(KitchenElement element: getKitchenElements()) {
			element.setRequireRefrech(true);
		}
	}
	
	

}
