package dressing.cam.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

import dressing.model.DesignException;
import dressing.model.Piece2D;

public class Tool {

	public static final String RADUIS_CODE = "R";

	public static final String RADUIS_COMPENSATION_CODE = "P";
	public static final String RADUIS_COMPENSATION_RIGHT_COMMAND = "G42";
	public static final String RADUIS_COMPENSATION_LEFT_COMMAND = "G41";
	public static final String RADIUS_COMPENSATION_OFF_COMMAND = "G40";

	public static final String TOOL_LENGHT_COMPENSATION_PLUS_COMMAND = "G43";
	public static final String TOOL_LENGHT_COMPENSATION_MINUS_COMMAND = "G44";
	public static final String TOOL_LENGHT_COMPENSATION_OFF_COMMAND = "G49";

	public static final String LEAD_IN_MOVE = "G0 X-1 Y-1\n G1 Z-0.125 \n G42 P0.125\n G1 X0 Y0\n";
	public static final String RAPID_MOVE_COMMAND = "G00";
	public static final String LINE_CUT_COMMAND = "G01";
	public static final String CIRCLE_CW_CUT_COMMAND = "G02";
	public static final String CIRCLE_CCW_CUT_COMMAND = "G03";
	public static final String HEIGHT_OFFSET_COMPENSATION_NEGATIVE = "G43";
	public static final String HEIGHT_OFFSET_COMPENSATION_POSITIVE = "G44";
	public static final String PROGRAM_UNIT_MILLIMETRE = "G21";
	public static final String PROGRAM_UNIT_INCHES = "G20";
	public static final String TOOL_CODE = "T";
	public static final String FEED_RATE_CODE = "F";
	public static final String SPINDLE_SPEED_CODE = "S";
	public static final String SPINDLE_ON_CW = "M03";
	public static final String SPINDLE_ON_CCW = "M03";
	public static final String SPINDLE_STOP = "M03";
	public static final String TOOL_CHANGE = "M06";

	public static final String MOVE_TO_ORIGIN = RAPID_MOVE_COMMAND + " Z20 \n X0 Y0";
	public static final String LEAD_IN_LINE = PROGRAM_UNIT_MILLIMETRE + "\n" + MOVE_TO_ORIGIN + "\n";
	public static final String CANNED_CYCLE_COMMAND = "G83";
	public static final String XYPLAN_SELECETION_COMMAND = "G17";
	public static final String X_CODE = "X";
	public static final String Y_CODE = "Y";
	public static final String Z_CODE = "Z";
	public static final String END_OF_LINE = "\n";
	public static final String Z_OFFSET = "20";

	public double flute_length;
	public double flute_diameter;
	public double cutter_length;
	public double cutter_diameter;

	public double raduisCompensation;
	public double radius;
	public String code;
	public String name;
	public double feed;
	public double spindleSpeed;
	public Unit unit;
	public double maxDepthStep;
	Properties props = new Properties();
	protected UUID ID = UUID.randomUUID();

	public Tool() {
		super();
	}

	public Tool(double raduisCompensation, double radius, String code, long feed, long spindleSpeed, Unit unit) {
		super();
		this.raduisCompensation = raduisCompensation;
		this.radius = radius;
		this.code = code;
		this.feed = feed;
		this.spindleSpeed = spindleSpeed;
		this.unit = unit;
	}

	public Tool(String name, String code) {
		super();
		this.name = name;
		this.code = code;
		this.unit = Unit.MILLIMETRE;
	}

	public Properties getProps() {
		return props;
	}

	public void setProps(Properties props) {
		this.props = props;
	}

	public Object put(Object key, Object value) {
		return this.props.put(key, value);
	}

	public String getProperty(String key) {
		return this.props.getProperty(key);
	}

	public String getProperty(String key, String defaultValue) {
		return this.props.getProperty(key, defaultValue);
	}

	public synchronized boolean isEmpty() {
		return this.props.isEmpty();
	}

	public synchronized Enumeration<Object> keys() {
		return this.props.keys();
	}

	public synchronized Enumeration<Object> elements() {
		return this.props.elements();
	}

	public synchronized Object get(Object key) {
		return this.props.get(key);
	}

	public synchronized void clear() {
		this.props.clear();
	}

	public Set<Object> keySet() {
		return this.props.keySet();
	}

	public Collection<Object> values() {
		return this.props.values();
	}

	public synchronized Object getOrDefault(Object key, Object defaultValue) {
		return this.props.getOrDefault(key, defaultValue);
	}

	public synchronized boolean remove(Object key, Object value) {
		return this.props.remove(key, value);
	}

	public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
		return this.props.replace(key, oldValue, newValue);

	}

	public Set<Map.Entry<Object, Object>> entrySet() {
		return this.props.entrySet();
	}

	public synchronized boolean containsKey(Object key) {
		return this.props.containsKey(key);
	}

	public double getRaduisCompensation() {
		return raduisCompensation;
	}

	public void setRaduisCompensation(double raduisCompensation) {
		this.raduisCompensation = raduisCompensation;
	}

	public double getRadius() {
		return radius;
	}

	public void setRadius(double radius) {
		this.radius = radius;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public double getFeed() {
		return feed;
	}

	public void setFeed(double feed) {
		this.feed = feed;
	}

	public double getSpindleSpeed() {
		return spindleSpeed;
	}

	public void setSpindleSpeed(double spindleSpeed) {
		this.spindleSpeed = spindleSpeed;
	}

	public Unit getUnit() {
		return unit;
	}

	public void setUnit(Unit unit) {
		this.unit = unit;
	}

	public double getMaxDepthStep() {
		return maxDepthStep;
	}

	public void setMaxDepthStep(double maxDepthStep) {
		this.maxDepthStep = maxDepthStep;
	}

	public double getFlute_length() {
		return flute_length;
	}

	public void setFlute_length(double flute_length) {
		this.flute_length = flute_length;
	}

	public double getFlute_diameter() {
		return flute_diameter;
	}

	public void setFlute_diameter(double flute_diameter) {
		this.flute_diameter = flute_diameter;
	}

	public double getCutter_length() {
		return cutter_length;
	}

	public void setCutter_length(double cutter_length) {
		this.cutter_length = cutter_length;
	}

	public double getCutter_diameter() {
		return cutter_diameter;
	}

	public void setCutter_diameter(double cutter_diameter) {
		this.cutter_diameter = cutter_diameter;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public static Tool getExperimentalTool() {
		Tool t1 = new Tool(2.5, 2.5, "05", 1000, 1000, Unit.MILLIMETRE);
		t1.setCutter_diameter(5);
		t1.setCutter_length(10);
		t1.setFlute_diameter(6);
		t1.setFlute_length(20);
		t1.setMaxDepthStep(10);

		return t1;
	}


	public static void generatePieceGcode(Piece2D piece) throws DesignException {

		for (PlanUsinage plan : PlanUsinage.values()) {
			// PlanUsinage plan =PlanUsinage.LEFT;
			String name = "gcode_" + plan.toString();
			List<Cercle2D> trous = Util.gettrousforPlan(plan, piece);
			List<Cuboid> cuboids = Util.getcuboidsforPlan(plan, piece);
			String gcode = "";
			if (trous.size() != 0) {
				gcode += generateGcodeforTrous(trous, plan);
			}
			if (cuboids.size() != 0) {
				gcode += generateGcodeforRainure(cuboids, plan);
			}
			piece.put(name, gcode);
			System.err.println(name + "  \n" + gcode);
		}
	}

	public static String generateGcodeforRainure(List<Cuboid> cuboids, PlanUsinage plan) {
		Comparator<Cuboid> comparX = new Comparator<Cuboid>() {

			@Override
			public int compare(Cuboid o1, Cuboid o2) {
				double x1 = o1.getxPos();
				double x2 = o2.getxPos();
				double y1 = o1.getyPos();
				double y2 = o2.getyPos();
				if (x1 >= x2 && y1 >= y2) {
					return -1;
				} else if (x1 <= x2 && y1 <= y2) {
					return 1;
				} else {
					if (x1 >= x2 && y1 <= y2) {
						return -1;
					} else if (x1 <= x2 && y1 >= y2) {
						return 1;
					}
				}
				return 0;
			}

		};
		cuboids.sort(comparX);
//		Tool tool = cuboids.get(0).getCube().getTool();
		String gcode = "";
//		gcode+=tool.initializer();
		for (Cuboid rn : cuboids) {
			gcode += rn.getGcode();

		}
		gcode += SPINDLE_STOP + END_OF_LINE;

		return gcode;

	}

	public static String generateGcodeforTrous(List<Cercle2D> trous, PlanUsinage plan) {
		Util.sortTrous(trous);
		String gcode = "";
		// on suppose tool cutter length == trou diametre
		// Trou first=trous.get(0);
		// gcode+=CANNED_CYCLE_COMMAND+" X"+getXcenter(first, plan)+
		// "Y"+getYcenter(first, plan)+"Z"+getDepth(first, plan)+" R0.1 P0.1 Q0.1
		// F2"+"\n";
//		Tool tool = trous.get(0).getTrou().getTool();
//		gcode+=tool.initializer();

		for (Cercle2D trou : trous) {
			gcode += trou.getGcode();

		}
		gcode += SPINDLE_STOP + END_OF_LINE;

		return gcode;
	}

	public String initializer() {
		String gcode = "";
		gcode += LEAD_IN_LINE;
		gcode += TOOL_CHANGE + TOOL_CODE + this.getCode() + END_OF_LINE;
		gcode += XYPLAN_SELECETION_COMMAND + END_OF_LINE;

		gcode += SPINDLE_ON_CW + END_OF_LINE;
		gcode += LINE_CUT_COMMAND + FEED_RATE_CODE + this.getFeed() + " " + SPINDLE_SPEED_CODE + this.getSpindleSpeed()
				+ END_OF_LINE;
		return gcode;
	}

	

	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((code == null) ? 0 : code.hashCode());
		long temp;
		temp = Double.doubleToLongBits(cutter_diameter);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(cutter_length);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(feed);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(flute_diameter);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(flute_length);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		temp = Double.doubleToLongBits(radius);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(raduisCompensation);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(spindleSpeed);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		result = prime * result + ((unit == null) ? 0 : unit.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Tool other = (Tool) obj;
		if (code == null) {
			if (other.code != null)
				return false;
		} else if (!code.equals(other.code))
			return false;
		if (Double.doubleToLongBits(cutter_diameter) != Double.doubleToLongBits(other.cutter_diameter))
			return false;
		if (Double.doubleToLongBits(cutter_length) != Double.doubleToLongBits(other.cutter_length))
			return false;
		if (Double.doubleToLongBits(flute_diameter) != Double.doubleToLongBits(other.flute_diameter))
			return false;
		if (Double.doubleToLongBits(flute_length) != Double.doubleToLongBits(other.flute_length))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

}

enum Unit {
	MILLIMETRE, Inch
}


