package gdxapp.ui;

import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class ActionItem {
	private final String title;
	private final Drawable icon;
	private final Runnable action;
	private final Boolean isEnable;
	private final String shortcut;

	public ActionItem(String title, Drawable icon, Runnable action, Boolean isEnable, String shortcut) {
		this.title = title;
		this.icon = icon;
		this.action = action;
		this.isEnable = isEnable;
		this.shortcut = shortcut;
	}

	public String getTitle() {
		return title;
	}

	public Drawable getIcon() {
		return icon;
	}

	public String getShortcut() {

		return shortcut == null ? "" : shortcut;
	}

	public boolean isEnabled() {
		return isEnable;
	}

	public void execute() {
		action.run();
	}

}
