package dressing.reporting.data.handle;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import dressing.ui.util.StaticUiObjects;
import param.Chant;
import param.Material;
import reporting.data.handle.PieceCoupe;

public class DressingChantGroup {
	private String matName;
	List<PieceCoupe> pieceCoupes = new ArrayList<PieceCoupe>();
	private double totalLongeur=0;
	private String stotalLongeur="";

	private double totalCost=0;
	private String stotalCost="";
	private String materialCost;

    private Chant chant; 
	public DressingChantGroup(Chant chant, double longeur) {
		super();
		this.chant=chant;
		this.matName = this.chant.getName();
		this.totalLongeur = longeur;
		init();
	}

	private void init() {
		
		this.totalCost=this.totalLongeur*chant.getPrice();
		
	        // Format the double value
	     stotalCost = StaticUiObjects.decimalMoneyFormat.format(totalCost);
	     materialCost=StaticUiObjects.decimalMoneyFormat.format(chant.getPrice());
	     stotalLongeur = StaticUiObjects.decimalMoneyFormat.format(totalLongeur).replace(",", ".");
	}
	public void calculate() {
		init();
	}
	public String getMatName() {
		return matName;
	}

	public void setMatName(String matName) {
		this.matName = matName;
	}

	public List<PieceCoupe> getPieceCoupes() {
		return pieceCoupes;
	}

	public void setPieceCoupes(List<PieceCoupe> pieceCoupes) {
		this.pieceCoupes = pieceCoupes;
	}

	public String getStotalCost() {
		return stotalCost;
	}

	public String getMaterialCost() {
		return materialCost;
	}

	public void addLength(double longeur) {
		totalLongeur+=longeur;
		init();
	}

	public double getTotalLongeur() {
		return totalLongeur;
	}

	public Chant getChant() {
		return chant;
	}

	public String getStotalLongeur() {
		return stotalLongeur;
	}

	public double getTotalCost() {
		return totalCost;
	}
	
}