/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import org.frs.debitage.cam.graphunit.PGraph;

public class PFill3DShape
extends PGraph
implements Serializable {
    private static final long serialVersionUID = 352L;
    String textcenterd;
    private final Point Startpoint;
    private final int Width;
    private final int Height;
    private final Color color;
    private Point temppoint;
    private int textsize = 15;
    private Font f;

    public PFill3DShape(Point ipoint, int iWidth, int iHeight, Color icolor) {
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.color = icolor;
        this.textcenterd = " ";
    }

    public PFill3DShape(Point ipoint, int iWidth, int iHeight, Color icolor, String text, double sizescalefactor) {
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.color = icolor;
        this.textcenterd = text;
        this.textsize = (int)((double)this.textsize / sizescalefactor) + 1;
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        g2d.fill3DRect(this.Startpoint.x, this.Startpoint.y, this.Width, this.Height, true);
        if (this.sizetypemodedimxdim) {
            this.textcenterd = String.valueOf(this.textcenterd) + " : " + this.Width + " X " + this.Height;
            this.drawCenteredString(this.textcenterd, this.Width, this.Height, g2d);
        } else {
            this.drawDimensionString(this.textcenterd, this.Width, this.Height, g2d);
        }
    }

    public void drawDimensionString(String s, int w, int h, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new Point();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        g2d.setColor(Color.black);
        this.f = new Font("Courier New", 0, this.piecefontsize);
        g2d.setFont(this.f);
        g2d.drawString("" + w, this.temppoint.x + w / 2, this.temppoint.y + 100);
        g2d.rotate(-1.5707963267948966, this.temppoint.x + 100, this.temppoint.y + h / 2);
        g2d.drawString("" + h, this.temppoint.x + 100, this.temppoint.y + h / 2);
        g2d.rotate(1.5707963267948966, this.temppoint.x + 100, this.temppoint.y + h / 2);
        this.f = new Font("SansSerif", 0, this.piecenamefontsize);
        g2d.setFont(this.f);
        g2d.drawString(s, this.temppoint.x + 50, this.temppoint.y + h - 50);
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        boolean inversed = false;
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new Point();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        g2d.setColor(Color.black);
        if (h > 2 * w) {
            int tempvalue = w;
            w = h;
            h = tempvalue;
            inversed = true;
        }
        this.f = new Font("SansSerif", 0, this.textsize);
        g2d.setFont(this.f);
        FontMetrics fm = g2d.getFontMetrics();
        while (w - fm.stringWidth(s) < 0) {
            --this.textsize;
            this.f = new Font("SansSerif", 0, this.textsize);
            g2d.setFont(this.f);
            fm = g2d.getFontMetrics();
        }
        ++this.textsize;
        ++this.textsize;
        this.f = new Font("SansSerif", 0, this.textsize);
        g2d.setFont(this.f);
        fm = g2d.getFontMetrics();
        if (!inversed) {
            int x = (w - fm.stringWidth(s)) / 2 + this.temppoint.x;
            int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2 + this.temppoint.y;
            g2d.drawString(s, x, y);
        } else {
            int y = (w - fm.stringWidth(s)) / 2 + this.temppoint.y;
            int x = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2 + this.temppoint.x;
            g2d.rotate(1.5707963267948966, x, y);
            g2d.drawString(s, x, y + h / 2);
            g2d.rotate(-1.5707963267948966, x, y);
        }
    }
}

