package org.frs.svg;

import java.util.ArrayList;

import com.badlogic.gdx.math.Vector3;


public class Box extends Geometry {

	private Vector3 origin;
	private Vector3 size;
	
	public Box(Vector3 origin, Vector3 size) {
		super();
		this.origin = origin;
		this.size = size;
		defineMesh(1);
	}

	@Override
	protected void defineMesh(int tesselation) {
		Vector3 halfSize = size.cpy().scl(0.5f);
		Vector3[] vertices = new Vector3[8];
		vertices[0]  = origin.cpy().add(halfSize.cpy().scl(1,1,1));
		vertices[1]  = origin.cpy().add(halfSize.cpy().scl(1,1,-1));
		vertices[2]  = origin.cpy().add(halfSize.cpy().scl(1,-1,1));
		vertices[3]  = origin.cpy().add(halfSize.cpy().scl(1,-1,-1));

		vertices[4]  = origin.cpy().add(halfSize.cpy().scl(-1,1,1));
		vertices[5]  = origin.cpy().add(halfSize.cpy().scl(-1,1,-1));
		vertices[6]  = origin.cpy().add(halfSize.cpy().scl(-1,-1,1));
		vertices[7]  = origin.cpy().add(halfSize.cpy().scl(-1,-1,-1));
		
		this.faces = new ArrayList<Triangle>();
		//top
		new Triangle(vertices[5], vertices[4], vertices[0]).tesselate(tesselation, faces);;
		new Triangle(vertices[5], vertices[0], vertices[1]).tesselate(tesselation, faces);
		//bottom
		new Triangle(vertices[7], vertices[6], vertices[2]).tesselate(tesselation, faces);
		new Triangle(vertices[7], vertices[2], vertices[3]).tesselate(tesselation, faces);
		//left
		new Triangle(vertices[5], vertices[4], vertices[7]).tesselate(tesselation, faces);
		new Triangle(vertices[4], vertices[7], vertices[6]).tesselate(tesselation, faces);
		//right
		new Triangle(vertices[1], vertices[0], vertices[3]).tesselate(tesselation, faces);
		new Triangle(vertices[0], vertices[3], vertices[2]).tesselate(tesselation, faces);
		//front
		new Triangle(vertices[4], vertices[6], vertices[2]).tesselate(tesselation, faces);
		new Triangle(vertices[4], vertices[2], vertices[0]).tesselate(tesselation, faces);
		//back
		new Triangle(vertices[5], vertices[7], vertices[3]).tesselate(tesselation, faces);
		new Triangle(vertices[3], vertices[1], vertices[5]).tesselate(tesselation, faces);
		
		calculateLinearMesh();

	}


	@Override
	public String toString() {
		return "Box [origin=" + origin + ", size=" + size + "]";
	}
	
	
	
	
	
	
}
