package org.frs.structures.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class Node<T> implements Iterable<Node<T>> {
	
	private UUID id;
	public T value;
	public String name;
	public final  ArrayList<Node<T>> children = new ArrayList<Node<T>>();
	public Node<T> parent;
	
	public Node() {	}
	
	public Node(String name) {
		this.name = name;
	}
	
	public Node(T value) {
		this.value = value;
	}

	public void addChildren(Node<T>... children) {
		for(Node<T> child: children)
			addChild(child);
	}
	
	private void addChild(Node<T> child) {
		children.add(child);
		if(child.getParent() != this)
			child.setParent(this);
	}
	
	public boolean isLeaf() {
		return children == null || children.isEmpty();
	}
	
	public void detach() {
		setParent(null);
	}

	private void removeChildren(Node<T>... nodes) {
		for(Node nodeX: nodes) {
			this.children.remove(nodeX);
		}
	}

	public T getValue() {
		return value;
	}

	public void setValue(T value) {
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public ArrayList<Node<T>> getChildren() {
		return children;
	}

	public void setChildren(List<Node<T>> children) {
		this.children.addAll(children);
	}

	public Node<T> getParent() {
		return parent;
	}

	public void setParent(Node<T> parent) {
		this.parent = parent;
		if(parent!= null && !parent.getChildren().contains(this))
			parent.addChild(this);
	}
	
	@Override
	public Iterator<Node<T>> iterator() {
		return new NodeIterator(this);
	}

	@Override
	public String toString() {
		return "Node [value=" + value + ", name=" + name + ", children=" + children.size() + ", parent=" + parent + "]";
	}
	
}
