package dressing.ui;

import com.badlogic.gdx.math.Vector3;

import gdxapp.object3d.WorldObject;

public class MoveCommand implements ChangeCommand {
	
	String name;
	String description;
	Vector3 oldPosition;
	Vector3 newPosition;
	WorldObject target;

	public MoveCommand(String name, String description, Vector3 oldPosition, Vector3 newPosition, WorldObject target) {
		super();
		this.name = name;
		this.description = description;
		this.oldPosition = oldPosition;
		this.newPosition = newPosition;
		this.target = target;
	}

	@Override
	public void redo() {
		if(target!=null){
			target.setRealWorldPosition(newPosition);
			target.setRequireRefrech(true);
			
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(target!=null){
			target.setRealWorldPosition(oldPosition);
			target.setRequireRefrech(true);
		}

	}
	@Override
	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Vector3 getOldPosition() {
		return oldPosition;
	}

	public void setOldPosition(Vector3 oldPosition) {
		this.oldPosition = oldPosition;
	}

	public Vector3 getNewPosition() {
		return newPosition;
	}

	public void setNewPosition(Vector3 newPosition) {
		this.newPosition = newPosition;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}

	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		oldPosition=null;
		newPosition=null;
	
	}

}
