package dressing.model.stock;

import param.AccessoireInstance;

public class ModelAccessoire extends Article {
	private AccessoireInstance accessoire;

	public ModelAccessoire(AccessoireInstance accessoire) {
		super(accessoire);
		this.accessoire = accessoire;
	}

	public AccessoireInstance getAccessoire() {
		return accessoire;
	}

	public void setAccessoire(AccessoireInstance accessoire) {	
		AccessoireInstance oldValue = this.accessoire;
		this.accessoire = accessoire;
		firePropertyChange("accessoire", oldValue, accessoire);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((accessoire == null) ? 0 : accessoire.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		ModelAccessoire other = (ModelAccessoire) obj;
		if (accessoire == null) {
			if (other.accessoire != null)
				return false;
		} else if (!accessoire.equals(other.accessoire))
			return false;
		return true;
	}
	

	
}
