/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public class URLCoder {
    public static String encode(String s) {
        return URLCoder.urlEncode(s.getBytes(StandardCharsets.UTF_8), true);
    }

    public static String compactEncode(String s) {
        return URLCoder.urlEncode(s.getBytes(StandardCharsets.UTF_8), false);
    }

    public static String decode(String s) {
        return new String(URLCoder.urlDecode(s), StandardCharsets.UTF_8);
    }

    private static String urlEncode(byte[] data, boolean encodeAllCharacters) {
        StringBuilder buf = new StringBuilder(data.length);
        int i = 0;
        while (i < data.length) {
            byte nextByte = data[i];
            if (!encodeAllCharacters && URLCoder.isAlphaNumericOrDot(nextByte)) {
                buf.append((char)nextByte);
            } else {
                buf.append('%');
                buf.append(Character.forDigit((nextByte & 0xF0) >>> 4, 16));
                buf.append(Character.forDigit(nextByte & 0xF, 16));
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isAlphaNumericOrDot(byte b) {
        return b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 46;
    }

    private static byte[] urlDecode(String encodedURL) {
        int len = encodedURL.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        int i = 0;
        while (i < len) {
            switch (encodedURL.charAt(i)) {
                case '%': {
                    if (len >= i + 3) {
                        os.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                    }
                    i += 3;
                    break;
                }
                case '+': {
                    os.write(32);
                    ++i;
                    break;
                }
                default: {
                    os.write(encodedURL.charAt(i++));
                }
            }
        }
        return os.toByteArray();
    }
}

