package gdxapp.fabs3d;

import java.util.Arrays;

import org.frs.svg.Triangle;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.MathUtilities;
import geometry.Triangle3D;


public class Quad {
	
	private final Vector3[] vertices = new Vector3[4];
	
	private String name;
	
	public Quad(Vector3... vertices ) {
		if(vertices.length > 3) {
			this.vertices[0] = vertices[0].cpy();
			this.vertices[1] = vertices[1].cpy();
			this.vertices[2] = vertices[2].cpy();
			this.vertices[3] = vertices[3].cpy();
		}
	}
	
	public Quad(String name, Vector3... vertices ) {
		this(vertices);
		this.name = name;
	}
	
	public Quad scaledCopy(float scale) {
		Vector3[] bounds = MathUtilities.getBoundaries(this.vertices);
		Vector3 dims = bounds[1].cpy().sub(bounds[0]);
		Vector3 center = bounds[0].cpy().add(dims.cpy().scl(0.5f));
		Vector3[] scaledVertices = new Vector3[4];
		for(int i = 0; i < this.vertices.length; i++) {
			scaledVertices[i] = this.vertices[i].cpy().sub(center).scl(scale).add(center);
		}
		
		Quad scaled = new Quad(scaledVertices);
		return scaled;
	}

	public Vector3[] getVertices() {
		return vertices;
	}

	



	@Override
	public String toString() {
		return "Quad [vertices=" + Arrays.toString(vertices) + ", name=" + name + "]";
	}

	public boolean contains(Vector3 point, float precision) {
		Triangle3D t0 = new Triangle3D(vertices[0], vertices[1], vertices[2]);
		Triangle3D t1 = new Triangle3D(vertices[1], vertices[2], vertices[3]);

		return t0.contains(point, precision)  || t1.contains(point, precision);
	}
	
	public Triangle[] getTriangles(){
		return new  Triangle[] {new Triangle(vertices[0], vertices[1], vertices[2]), new Triangle(vertices[2], vertices[3], vertices[0])};
	}


	public boolean hasVertex(Vector3 corner, float epsilon) {
		for(Vector3 vertex: vertices) {
			if(vertex.epsilonEquals(corner, epsilon))
				return true;
		}
		return false;
	}



	public boolean intersect(Quad other) {
		for(var triangle: getTriangles()) {
			for(var triangleX: other.getTriangles()) {
				if(triangle.intersect(triangleX))
					return true;
			}
		}
		return false;
	}	
}
