package dressing.model.persistence.dpos;

import com.badlogic.gdx.graphics.Color;


public class ColorDPO implements DPO<Color>{
	
	private final float[] value = new float[4];

	@Override
	public DPO<Color> from(Color color) {
		ColorDPO colorDpo = new ColorDPO();
		colorDpo.value[0] = color.r;
		colorDpo.value[1] = color.g;
		colorDpo.value[2] = color.b;
		colorDpo.value[3] = color.a;
		return colorDpo;
	}
	
	@Override
	public Color get() {
		return new Color(value[0], value[1], value[2], value[3]);
	}

	public float[] getValue() {
		return value;
	}

	public void setValue(float[] value) {
		for(int i = 0; i < value.length; i++) {
			this.value[i]= value[i];
		}
	}
	
}
