package reporting;

import org.frs.structures.grid.Grid;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.cam.model.PlanUsinage;

public class PieceProjectionGenerator {
		
	public Grid createGrid(Piece2D piece, float[] padding ) {
		float padTop, padBottom, padLeft, padRight;
		if(padding.length == 4) {
			padTop = padding[0];
			padBottom = padding[1];
			padLeft = padding[2];
			padRight = padding[3];
		}else if(padding.length == 2) {
			padTop = padding[0];
			padBottom = padding[0];
			padLeft = padding[1];
			padRight = padding[1];
		}else {
			padTop = padding[0];
			padBottom = padding[0];
			padLeft = padding[0];
			padRight = padding[0];
		}
		float length = (float)piece.getLongeurext();
		float height = (float)piece.getHauteurext();
		float depth = (float)piece.getProfondeurext();
		
		float[] columnsWidth = new float[] {padLeft + depth + padRight , padLeft + length + padRight, padLeft + depth + padRight};
		float[] rowsHeight = new float[] {padTop + depth + padBottom, padTop + height + padBottom, padTop + depth + padBottom};
		
		Grid grid = new Grid(columnsWidth, rowsHeight, padTop, padBottom, padLeft, padRight);
		grid.populate();
		grid.get(0, 1).setValue(PlanUsinage.RIGHT);
		grid.get(1, 0).setValue(PlanUsinage.DOWN);
		grid.get(1, 1).setValue(PlanUsinage.FRONT);
		grid.get(1, 2).setValue(PlanUsinage.TOP);
		grid.get(2, 1).setValue(PlanUsinage.LEFT);
		return grid;
	}
	
	

}
