package dressing.ui.usinage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;

import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import param.Tool;

public class MaterialEditor  implements IUpdateStructure{
	@Inject 
	IEclipseContext eclipsecontext;
	
	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;
	@Inject 
	ESelectionService selectionService;
	
	@Inject
	IEventBroker eventBroker;
	
	@Inject
	private MDirtyable dirty;
	private MaterialEditorComposite materialEditorComosite;
	public MaterialEditor() {
	}

	/**
	 * Create contents of the view part.
	 * @param parent
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		materialEditorComosite=new MaterialEditorComposite(parent,  SWT.NONE);
		materialEditorComosite.setDirty(dirty);
		materialEditorComosite.setHandlerService(handlerService);
		materialEditorComosite.setCommandService(commandService);
		materialEditorComosite.setEventBroker(eventBroker);

	}

	public MDirtyable getDirty() {
		return dirty;
	}

	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}

	public MaterialEditorComposite getMaterialEditorComosite() {
		return materialEditorComosite;
	}

	public void setMaterialEditorComosite(MaterialEditorComposite materialEditorComosite) {
		this.materialEditorComosite = materialEditorComosite;
	}

	@Focus
	public void setFocus() {
		// Set the focus
		materialEditorComosite.setFocus();
	}
	
	@PreDestroy
	public void dispose() {
		materialEditorComosite.dispose();
	}
	public boolean isDirty() {
		return dirty.isDirty();
	}
	
	@Persist
	@Override
	public void run() throws DesignException {
		materialEditorComosite.run();
	}
	
	@Override
	public void cancel() {
		materialEditorComosite.cancel();
	}
	@Persist
	public void save() throws DesignException {
		run();
	}

}
