package dressing.ui.engine3d.sceneconfig;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;

import com.badlogic.gdx.math.Vector3;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.ModelProvider;
import gdxapp.object3d.DoorHandle;
import gdxapp.scenes.SceneEvent;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import supercad.provider.FacadeHandleProvider;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;

import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;

public class HandlerConfigComposite extends Composite implements PropertyChangeListener{
	
	private DoorHandle doorHandle;
	
	private TableComboViewer tableComboViewer;
	private Spinner widthSpinner;
	private Spinner heightSpinner;
	private Spinner depthSpinner;
	private Button btnPreview;
	private TableComboViewer tcvTexture;
	
	private final Vector3 size = new Vector3();
	private PbrMaterial mtl;
	private DoorHandle tmpDoorHandle;
	
	
	public HandlerConfigComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setRightWidth(300);
		
		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_1);
		GridLayout gl_composite_1 = new GridLayout(2, false);
		gl_composite_1.marginTop = 80;
		composite_1.setLayout(gl_composite_1);
		
		Label lblMotif = new Label(composite_1, SWT.NONE);
		lblMotif.setText("Motif");
		
		tableComboViewer = new TableComboViewer(composite_1, SWT.NONE);
		TableCombo tableCombo = tableComboViewer.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer.setInput(FacadeHandleProvider.getInstance().getHandlers());		
		tableCombo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
						tmpDoorHandle  = ((DoorHandle)tableComboViewer.getStructuredSelection().getFirstElement());
						btnPreview.setImage(getImage(tmpDoorHandle));						
						updateDimsCompnents(tmpDoorHandle.getDimension());
			}
		});
		
		Label lblCouleur = new Label(composite_1, SWT.NONE);
		lblCouleur.setText("Couleur");
		tcvTexture = new TableComboViewer(composite_1, SWT.NONE);
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tcvTexture.setInput(ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS));

		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				mtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
			}
		});
		Label lblDimension = new Label(composite_1, SWT.NONE);
		lblDimension.setText("Dimensions");
		new Label(composite_1, SWT.NONE);
		
		Composite composite_4 = new Composite(composite_1, SWT.NONE);
		composite_4.setLayoutData(new GridData(SWT.CENTER, SWT.FILL, false, true, 2, 1));
		composite_4.setLayout(new RowLayout(SWT.HORIZONTAL));
		
		Label lblX = new Label(composite_4, SWT.NONE);
		lblX.setText("L:");
		
		widthSpinner = new Spinner(composite_4, SWT.BORDER);
		widthSpinner.setMaximum(1000);
		widthSpinner.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				size.x =  widthSpinner.getSelection()/1000.0f;
			}
		});
		
		Label lblY = new Label(composite_4, SWT.NONE);
		lblY.setText("H:");
		
		heightSpinner = new Spinner(composite_4, SWT.BORDER);
		heightSpinner.setMaximum(1000);
		heightSpinner.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				size.y =  heightSpinner.getSelection()/1000.0f;
			}
		});
		
		Label lblX_1_1 = new Label(composite_4, SWT.NONE);
		lblX_1_1.setText("P:");
		
		depthSpinner = new Spinner(composite_4, SWT.BORDER);
		depthSpinner.setMaximum(1000);
		depthSpinner.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				size.z =  depthSpinner.getSelection()/1000.0f;
			}
		});
		
		
		
		
		Composite composite_2 = new Composite(banner, SWT.EMBEDDED);
		banner.setRight(composite_2);
		composite_2.setSize(400, 400);
		composite_2.setLayout(new GridLayout(1, false));
		
		btnPreview = new Button(composite_2, SWT.CENTER);
		GridData gd_btnPreview = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_btnPreview.heightHint = 215;
		btnPreview.setLayoutData(gd_btnPreview);
		
		Composite composite_3 = new Composite(banner, SWT.NONE);
		banner.setBottom(composite_3);

	}

	
	public void bind(DoorHandle doorhandle) {
		this.doorHandle = doorhandle;
		var handle = FacadeHandleProvider.getInstance().getHandleById(this.doorHandle.getModelId());
		tableComboViewer.setSelection(new StructuredSelection(handle));
		tableComboViewer.getTableCombo().notifyListeners(SWT.Selection, null);
		if(doorhandle.getMaterial() != null) {
			try {
				for(var mtlX: ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS)) {
					if(mtlX.getName().equals(doorHandle.getMaterial().getName())) {
						tcvTexture.setSelection(new StructuredSelection(mtlX));
						break;
					}
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
		
	}
	
	public void updateDoorHandle() {
		if(this.tmpDoorHandle == null || mtl == null)
			return;
		this.doorHandle.setModelId(tmpDoorHandle.getModelId());
		this.doorHandle.setMaterial(mtl);
		this.doorHandle.setDimension(size.x, size.y, size.z);
		this.doorHandle.setName(tmpDoorHandle.getName());
		this.doorHandle.setPrice(tmpDoorHandle.getPrice());
		this.doorHandle.setPreviewPath(tmpDoorHandle.getPreviewPath());
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.HANDLER_CHANGED.name(), this.doorHandle));
	}
	
	
	protected void textureChanged() {
		this.mtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
	}

	protected Image getImage(DoorHandle doorHandle) {
		Image image = new Image(getDisplay(), doorHandle.getPreviewPath());
		return image;
	}

	protected void updateDimsCompnents(Vector3 dims) {
		this.widthSpinner.setSelection((int)(dims.x * 1000));
		this.heightSpinner.setSelection((int)(dims.y * 1000));
		this.depthSpinner.setSelection((int)(dims.z * 1000));
	}
	

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		
	}

	
}
