package dressing.ui;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.Space3DFree;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import param.MechanicPublicParam;

public class ScaleCommand implements ChangeCommand {
	
	String name;
	String description;
	Vector4 oldDimension;
	Vector4 newDimension;
	WorldObject target;
	
	public ScaleCommand(String name, String description, Vector4 oldDimension, Vector4 newDimension,
			WorldObject target) {
		super();
		this.name = name;
		this.description = description;
		this.oldDimension = oldDimension;
		this.newDimension = newDimension;
		this.target = target;
	}

	@Override
	public void redo() {
		if(target!=null){
			KitchenElement element = null;
			if(target instanceof KitchenElement) {
				element = (KitchenElement) target;
			}
			if(element == null)
				return;
			
			if( element.getMechanicDesign()!=null &&  element.getDesignObject()!=null ) {
				try {
					MechanicPublicParam paramL = element.getMechanicDesign().getPublicParam("global.l");
					if (paramL != null) {
						paramL.setDefaultvalue(String.valueOf((int)(newDimension.x*1000)));			
					}
					MechanicPublicParam paramH = element.getMechanicDesign().getPublicParam("global.h");
					if (paramH != null) {
						paramH.setDefaultvalue(String.valueOf((int)(newDimension.y*1000)));			
										}
					MechanicPublicParam paramP = element.getMechanicDesign().getPublicParam("global.p");
					if (paramP != null) {
						paramP.setDefaultvalue(String.valueOf((int)(newDimension.z*1000)));			
					}
					MechanicPublicParam paramlargeur = element.getMechanicDesign().getPublicParam("global.largeur");
					if (paramlargeur != null && oldDimension.w!=-1) {
						paramlargeur.setDefaultvalue(String.valueOf((int)(newDimension.w*1000)));			
					}
					Space3DFree space=((Space3DFree)element.getDesignObject());
					space.update();
					Vector4 dimension = new Vector4((float)space.getLongeurext()/1000f, (float)space.getHauteurext()/1000f,
							(float)space.getProfondeurext()/1000f,0);
					element.setRealWorldDimension(dimension);
					element.firePropertyChange("dimension", null, target.getRealWorldDimension());
					element.setRequireRefrech(true);
				} catch (Exception e) {
					
					e.printStackTrace();

				}
			}
			else {
				target.setRealWorldDimension(new Vector4(newDimension.x,newDimension.y,newDimension.z,0));
				target.firePropertyChange("dimension", null, target.getRealWorldDimension());
				target.setRequireRefrech(true);
			}
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(target!=null){
			KitchenElement element = null;
			if(target instanceof KitchenElement) {
				element = (KitchenElement) target;
			}
			if(element == null)
				return;
			if(element.getMechanicDesign()!=null &&  element.getDesignObject()!=null ) {
				try {
					MechanicPublicParam paramL = element.getMechanicDesign().getPublicParam("global.l");
					if (paramL != null) {
						paramL.setDefaultvalue(String.valueOf((int)(oldDimension.x*1000)));			
					}
					MechanicPublicParam paramH = element.getMechanicDesign().getPublicParam("global.h");
					if (paramH != null) {
						paramH.setDefaultvalue(String.valueOf((int)(oldDimension.y*1000)));			
					}
					MechanicPublicParam paramP = element.getMechanicDesign().getPublicParam("global.p");
					if (paramP != null) {
						paramP.setDefaultvalue(String.valueOf((int)(oldDimension.z*1000)));			
					}
					MechanicPublicParam paramlargeur = element.getMechanicDesign().getPublicParam("global.largeur");
					if (paramlargeur != null && oldDimension.w!=-1) {
						paramlargeur.setDefaultvalue(String.valueOf((int)(oldDimension.w*1000)));									
					}
					Space3DFree space=((Space3DFree)element.getDesignObject());
					space.update();
					Vector4 dimension = new Vector4((float)space.getLongeurext()/1000f, (float)space.getHauteurext()/1000f,
							(float)space.getProfondeurext()/1000f,0);
					element.setRealWorldDimension(dimension);
					element.firePropertyChange("dimension", null, target.getRealWorldDimension());
					element.setRequireRefrech(true);
				} catch (Exception e) {
					
					e.printStackTrace();

				}
			}else {
				target.setRealWorldDimension(new Vector4(oldDimension.x,oldDimension.y,oldDimension.z,0));
				target.firePropertyChange("dimension", null, target.getRealWorldDimension());
				target.setRequireRefrech(true);
			}
			
		}

	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Vector4 getOldDimension() {
		return oldDimension;
	}

	public void setOldDimension(Vector4 oldDimension) {
		this.oldDimension = oldDimension;
	}

	public Vector4 getNewDimension() {
		return newDimension;
	}

	public void setNewDimension(Vector4 newDimension) {
		this.newDimension = newDimension;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}
	
	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		oldDimension=null;
		newDimension=null;
	
	}
}
