package dressing.config.ui;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import dressing.config.WorkspaceConfiguration;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;

public class IconSettingWindow extends Window {
	
	
	
	Iconmanager iconManager = new Iconmanager();
	 
	
	
	
	
	

	public IconSettingWindow(Shell parent) {
		super(parent);}
	
	@Override
    protected Control createContents(Composite parent) {
	
        Iconmanager iconManager = new Iconmanager();
        iconManager.loadIconsFromFolder(WorkspaceConfiguration.ICONS, parent.getDisplay());
        
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, SWT.V_SCROLL );
        scrolledComposite.setLayout(new GridLayout(1, false));
        scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
       
        Composite mainComposite = new Composite(scrolledComposite, SWT.NONE);
        mainComposite.setLayout(new FillLayout(SWT.VERTICAL));

        for (String url : iconManager.getIconMap().keySet()) {
            IconChangerComposite iconChanger = new IconChangerComposite(mainComposite, SWT.BORDER, WorkspaceConfiguration.ICONS + File.separator + url);
        }
        scrolledComposite.setContent(mainComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
      //  scrolledComposite.setSize(300, 600);
        
       
        scrolledComposite.setMinSize(mainComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
        
        return scrolledComposite;
    }

}
