/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.keys;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class KeyPairGen {
    public KeyPair genNewPair(int size) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(size);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    public String saveKeyToPEM(String header, byte[] keyBytes) throws IOException {
        String base64 = Base64.getEncoder().encodeToString(keyBytes);
        StringBuilder pem = new StringBuilder();
        pem.append("-----BEGIN ").append(header).append("-----\n");
        int i = 0;
        while (i < base64.length()) {
            pem.append(base64, i, Math.min(i + 64, base64.length())).append("\n");
            i += 64;
        }
        pem.append("-----END ").append(header).append("-----\n");
        return pem.toString();
    }

    public static Key loadKey(byte[] keyData, KeyType type) {
        String keyPEM = new String(keyData);
        String header = String.format("-----BEGIN %s KEY-----", new Object[]{type});
        String footer = String.format("-----END %s KEY-----", new Object[]{type});
        keyPEM = keyPEM.replace(header, "").replace(footer, "").replaceAll("\\s+", "");
        byte[] decoded = Base64.getDecoder().decode(keyPEM);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            if (type == KeyType.PRIVATE) {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoded);
                return keyFactory.generatePrivate(keySpec);
            }
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decoded);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String ... strings) {
        KeyPairGen keyTools = new KeyPairGen();
        String filePath = "C:\\keys\\private.pem";
        try {
            byte[] data = Files.readAllBytes(Paths.get(filePath, new String[0]));
            KeyPairGen.loadKey(data, KeyType.PRIVATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum KeyType {
        PUBLIC,
        PRIVATE;

    }
}

