package resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

public class IconsResource {

	private static final Map<String, byte[]> IMAGE_DATA_CACHE = new HashMap<>();

	public static final String COPY = "icons/copy-24.png";
	public static final String EDIT = "icons/edit-24.png";
	public static final String RESIZE_HORIZANTAL = "icons/resize-horizontal-24.png";
	public static final String PASTE = "icons/paste-24.png";
	public static final String REMOVE = "icons/remove-24.png";
	public static final String PAINT = "icons/paint-24.png";
	
	
	
	private static byte[] getImageBytes(String path) {
		return IMAGE_DATA_CACHE.computeIfAbsent(path, p -> {
			try (InputStream stream = IconsResource.class.getClassLoader().getResourceAsStream(p)) {
				if (stream == null) {
					throw new RuntimeException("Resource not found: " + p);
				}
				return stream.readAllBytes();
			} catch (IOException e) {
				throw new RuntimeException("Failed to read image: " + p, e);
			}
		});
	}

	public static Image getImage(String path) {
		byte[] data = getImageBytes(path);
		return new Image(getDisplay(), new ByteArrayInputStream(data));
	}

	public static Drawable getDrawable(String path) {
		byte[] data = getImageBytes(path);
		Texture texture = new Texture(new com.badlogic.gdx.files.FileHandle(path) {
			@Override
			public InputStream read() {
				return new ByteArrayInputStream(data);
			}
		});
		return new TextureRegionDrawable(texture);
	}

	private static Display getDisplay() {
		Display current = Display.getCurrent();
		return (current != null) ? current : Display.getDefault();
	}

	
	
	
	
	
	
	
	
	
	
	
	
	
	// --- COPY ---
	public static Image getCopyImage() {
	    return getImage(COPY);
	}

	public static Drawable getCopyDrawable() {
	    return getDrawable(COPY);
	}

	// --- PASTE ---
	public static Image getPasteImage() {
	    return getImage(PASTE);
	}

	public static Drawable getPasteDrawable() {
	    return getDrawable(PASTE);
	}

	// --- REMOVE ---
	public static Image getRemoveImage() {
	    return getImage(REMOVE);
	}

	public static Drawable getRemoveDrawable() {
	    return getDrawable(REMOVE);
	}

	// --- EDIT ---
	public static Image getEditImage() {
	    return getImage(EDIT);
	}

	public static Drawable getEditDrawable() {
	    return getDrawable(EDIT);
	}

	// --- RESIZE_HORIZONTAL ---
	public static Image getResizeHorizontalImage() {
	    return getImage(RESIZE_HORIZANTAL);
	}

	public static Drawable getResizeHorizontalDrawable() {
	    return getDrawable(RESIZE_HORIZANTAL);
	}

	// --- PAINT ---
	public static Image getPaintImage() {
	    return getImage(PAINT);
	}

	public static Drawable getPaintDrawable() {
	    return getDrawable(PAINT);
	}
	
	
	
}
