package gdxapp.object3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;

import dressing.controller.tools.ToolController;
import dressing.events.EventDriver;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.ProjectManager;
import dressing.model.Space3D;
import dressing.ui.ChangeCommand;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.GeometricObjectConfigWindow;
import dressing.ui.util.MesureWidow;
import dressing.ui.util.ModelInstanceConfigWindow;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.DrawingHelper;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.SurfaceScreen;

public class Object2DEventProcessor extends InputListener {

	private final String TAG = Object2DEventProcessor.class.getName();

	float xoffset, yoffset, lastX, lastY, rotation;

	Object2D object2D;

	private long lastClickDate = System.currentTimeMillis();

	public Object2DEventProcessor(Object2D object2d) {
		super();
		object2D = object2d;
		object2d.setTouchable(Touchable.enabled);
	}

	@Override
	public boolean handle(Event e) {
		if (!ToolController.getInstance().isSELECT_Objects()) {
			return false;
		}

		if (!(e instanceof InputEvent))
			return false;
		InputEvent event = (InputEvent) e;
		if (event.getType().equals(InputEvent.Type.touchDragged)) {
			if (GroupSelection.getInstance().getSelection() != null) {
				if (GroupSelection.getInstance().getSelection().size() > 1) {
					return false;
				}
			}
		}
		if(object2D!=null && object2D.getWorldObject()!=null && !object2D.getWorldObject().isHidden())
		{
			return super.handle(e);
		}
		return false;
	}

	@Override
	public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
		if (object2D!=null&&object2D.getStage() != null) {
			object2D.getStage().setScrollFocus(object2D);
		}
		
		if(button == Input.Buttons.RIGHT) {
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("location", new Vector2(object2D.getX() + x, object2D.getY() + y));
			eventData.put("source", object2D);
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.OBJECT_RIGHT_CLICK.name(), eventData);
			EventDriver.getDriver().deliverEvent(sceneEvent);
		}else {
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("location", new Vector2(object2D.getX() + x, object2D.getY() + y));
			eventData.put("source", object2D);
			dressing.events.Event sceneEvent = new dressing.events.Event(SceneEvent.OBJECT_SELECTED.name(), eventData);
			EventDriver.getDriver().deliverEvent(sceneEvent);
		}
		
		
		
		object2D.calculateSurroundingEdges();
		xoffset = x;
		yoffset = y;
		rotation = object2D.getRotation();
		if (Gdx.input.isKeyPressed(Keys.CONTROL_LEFT)) {
			GroupSelection.getInstance().toggleSelection(this.object2D);
		} else {
			GroupSelection.getInstance().clearSelection();
			GroupSelection.getInstance().addObject(this.object2D);
		}
		long newClickDate = System.currentTimeMillis();
		long timeSinceLastClick = newClickDate - lastClickDate;
		lastClickDate = newClickDate;

		if (object2D != null && object2D.getWorldObject() != null && button == Input.Buttons.LEFT) {

			if (timeSinceLastClick < 250) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						if(object2D.getWorldObject().getType().equals(ObjectType.POLY)) {
							GeometricObjectConfigWindow window = GeometricObjectConfigWindow.getInstance();
							window.setGeometryObject((GeometryObject) object2D.getWorldObject());
							window.show();
						}else if (object2D.getWorldObject().getType().equals(ObjectType.DEFINED)){
							
							MesureWidow window = MesureWidow.getInstance();
							window.setObject2d(object2D);
							window.show();
						}else {
							ModelInstanceConfigWindow window = ModelInstanceConfigWindow.getInstance();
							window.setObject2D(object2D);
							window.open();
						}
					}
				});
			} else {
				if (object2D.getWorldObject() instanceof KitchenElement
						&& ((KitchenElement) object2D.getWorldObject()).getDesignObject() instanceof DesignObject3D) {
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							GdxPart.setSelectedElement((Space3D) ((KitchenElement) object2D.getWorldObject()).getDesignObject());

						}
					});
				}
				object2D.setOldRotation(object2D.getWorldObject().getRotation());
				object2D.setOldPosition(object2D.getWorldObject().getRealWorldPosition());
				object2D.setOldDimention(object2D.getWorldObject().getObjectDimention());
			}
		}
		if (object2D != null && object2D.getWorldObject() != null && button == Input.Buttons.RIGHT) {
			if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
				SurfaceController controller = ((SurfaceController) ((AbstractScreen) Scene.game.getScreen())
						.getController());
				if (controller.getReference() == object2D) {
					controller.setReference(null);
				} else {
					controller.setReference(object2D);
				}
			}
		}
		return true;
	}

	@Override
	public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
		Object object2 = ProjectManager.getManager().getCurrentScene().getSceneObjects();
        object2.toString();
		object2D.setHidden(false);
		object2D.setRotation(rotation);
		CommandStack command = new CommandStack("change from window submit", "change from window",
				new ArrayList<ChangeCommand>());
		float newRotation = object2D.getWorldObject().getRotation();
		Vector3 newPosition = object2D.getWorldObject().getRealWorldPosition();
		Vector4 newDimention = object2D.getWorldObject().getObjectDimention();
		boolean propertyChanged = false;
		if (newRotation != object2D.getOldRotation()) {
			RotateCommand rotate = new RotateCommand("rotate " + object2D.getWorldObject().getName(), "rotate",
					object2D.getWorldObject(), object2D.getOldRotation(), newRotation);
			command.addCommand(rotate);
			propertyChanged = true;
		}
		if (!newPosition.epsilonEquals(object2D.getOldPosition(), 0.001f)) {
			MoveCommand move = new MoveCommand("move " + object2D.getWorldObject(), "move", object2D.getOldPosition(),
					newPosition, object2D.getWorldObject());
			command.addCommand(move);
			propertyChanged = true;
		}
		if (!newDimention.epsilonEquals(object2D.getOldDimention(), 0.001f)) {
			ScaleCommand scale = new ScaleCommand("move " + object2D.getWorldObject().getName(), "move",
					object2D.getOldDimention(), newDimention, object2D.getWorldObject());
			command.addCommand(scale);
			propertyChanged = true;
		}
		if (propertyChanged && !Gdx.input.isKeyPressed(Input.Keys.SHIFT_LEFT)
				&& !Gdx.input.isKeyPressed(Input.Keys.SHIFT_RIGHT)) {

			Display.getDefault().asyncExec(new Runnable() {

				@Override
				public void run() {
					float oldRotation = object2D.getWorldObject().getRotation();
					Vector3 oldPosition = object2D.getWorldObject().getRealWorldPosition();
					Vector4 oldDimention = object2D.getWorldObject().getObjectDimention();
					((AbstractScreen) Scene.game.getScreen()).getController().rectifyPosition(object2D);
					float newRotation = object2D.getWorldObject().getRotation();
					Vector3 newPosition = object2D.getWorldObject().getRealWorldPosition();
					Vector4 newDimention = object2D.getWorldObject().getObjectDimention();
					if (newRotation != oldRotation) {
						RotateCommand rotate = new RotateCommand("rotate " + object2D.getWorldObject().getName(),
								"rotate", object2D.getWorldObject(), oldRotation, newRotation);
						command.addCommand(rotate);
					}
					if (!newPosition.epsilonEquals(oldPosition, 0.0000001f)) {
						MoveCommand move = new MoveCommand("move " + object2D.getWorldObject().getName(), "move",
								oldPosition, newPosition, object2D.getWorldObject());
						command.addCommand(move);
					}
					if (!newDimention.epsilonEquals(oldDimention, 0.0000001f)) {
						ScaleCommand scale = new ScaleCommand("move " + object2D.getWorldObject().getName(), "move",
								oldDimention, newDimention, object2D.getWorldObject());
						command.addCommand(scale);
					}
					if (command.getStack() != null && command.getStack().size() > 0) {
						if (((AbstractScreen) Scene.game.getScreen()).getController()
								.getChangeCommandController() != null) {
							((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
									.addCommand(command);
						}

					}
					System.gc();

				}
			});
		} else if (command.getStack() != null && command.getStack().size() > 0) {
			if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
				((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
						.addCommand(command);
			}
		}
		Object objects = ProjectManager.getManager().getCurrentScene().getSceneObjects();
        objects.toString();
	}

	@Override
	public void touchDragged(InputEvent event, float x, float y, int pointer) {
		float xmov = x - xoffset;
		float ymov = y - yoffset;

		if (!(Scene.game.getScreen() instanceof SurfaceScreen)) {
			object2D.setRotation(0);
			object2D.setZIndex(100);
			//object2D.setHidden(true);
			ProjectManager.getManager().getCurrentScene().removeConstraint(object2D.getWorldObject());
		}

		float newX = object2D.getX() + xmov;
		float newY = object2D.getY() + ymov;
		if (newX < 0) {
			newX = 0;
			xmov = 0;
		}
		if (object2D != null && object2D.getStage() != null
				&& newX > object2D.getStage().getWidth() - object2D.getWidth()) {
			newX = object2D.getStage().getWidth() - object2D.getWidth();
			xmov = newX - object2D.getX();
		}
		if (newY < 0) {
			newY = 0;
			ymov = 0;

		}
		if (object2D != null && object2D.getStage() != null
				&& newY > object2D.getStage().getHeight() - object2D.getHeight()) {
			newY = object2D.getStage().getHeight() - object2D.getHeight();
			ymov = newY - object2D.getY();
		}
		if (object2D.getWorldObject().isMoveable() || (Gdx.input.isKeyPressed(Input.Keys.W)
				|| (object2D.getWorldObject() instanceof Wall && ToolController.getInstance().isALLOW_WALL_MOVE()))) {
			object2D.setPosition(newX, newY);

			Vector2 a = new Vector2(), b = new Vector2();
			object2D.getClosestObject(a, b);
		}

		if (Scene.game.getScreen() instanceof SurfaceScreen) {
			DrawingHelper.drawPositionOnWalls(object2D);
		}

	}

	@Override
	public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {

	}

	@Override
	public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
		long newClickDate = System.currentTimeMillis();
		if (object2D != null && object2D.getStage() != null && object2D.equals(object2D.getStage().getScrollFocus())
				&& newClickDate - lastClickDate > 2000) {
			object2D.getStage().setScrollFocus(null);
		}
	}

	@Override
	public boolean scrolled(InputEvent event, float x, float y, int amount) {
		if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController || object2D.getWorldObject().getType() == ObjectType.POLY) {
			return false;
		}
//		if(!object2D.getWorldObject().isStaticobject()) {
		float oldRotation = object2D.getWorldObject().getRotation();
		float rotation = 15 * (amount / Math.abs(amount));
		object2D.rotateBy(rotation);
		rotation = object2D.getRotation();
		rotation = rotation % 360;
		object2D.getWorldObject().setRotation(rotation);
		object2D.positionChanged();
		float newRotation = object2D.getWorldObject().getRotation();
		RotateCommand rotate = new RotateCommand("rotate " + object2D.getWorldObject().getName(), "rotate",
				object2D.getWorldObject(), oldRotation, newRotation);
		if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
			((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(rotate);
		}
//		}
		return true;
	}

	public Edge detectEdgeSelection(Vector3 point) {
		Edge selectedEdge = null;
		List<Edge> edges = object2D.calculateEdges();
		for (Edge edge : edges) {
			if (selectedEdge == null) {
				selectedEdge = edge;
				continue;
			}
			float dist1 = MathUtilities.lineToPointDistance(point.x, point.y, edge.getV0().x, edge.getV0().y,
					edge.getV1().x, edge.getV1().y);
			float dist2 = MathUtilities.lineToPointDistance(point.x, point.y, selectedEdge.getV0().x,
					selectedEdge.getV0().y, selectedEdge.getV1().x, selectedEdge.getV1().y);
			if (dist1 < dist2)
				selectedEdge = edge;
		}

		for (Edge edge : edges) {
			edge.setSelected(false);
		}
		if (selectedEdge != null) {
			float dist2 = MathUtilities.lineToPointDistance(point.x, point.y, selectedEdge.getV0().x,
					selectedEdge.getV0().y, selectedEdge.getV1().x, selectedEdge.getV1().y);
			if (dist2 < 100) {
				selectedEdge.setSelected(true);
				return selectedEdge;
			}
		}

		return null;
	}

	@Override
	public boolean keyUp(InputEvent event, int keycode) {
		if (keycode == Keys.R) {
			object2D.adjustRotation();
			return true;
		}else if (keycode == Keys.P) {
			object2D.adjustPosition();
			return true;
		}else if (keycode == Keys.M) {
			int a = 0;
			int b = 5;
			float r = b/a;
			return r>0;
		}else if(keycode == Keys.FORWARD_DEL) {
			EventDriver.getDriver().deliverEvent(SceneEvent.REMOVE_OBJECT_REQUEST, object2D);
		}
		return false;
	}

	// handlers of group selection
	public boolean touchDownGrp(InputEvent event, float x, float y, int pointer, int button) {
//		Gdx.app.debug(TAG, "touch down group at X: " + x + "Y: " + y);
		xoffset = x;
		yoffset = y;
		rotation = object2D.getRotation();

		if (Gdx.input.isKeyPressed(Keys.CONTROL_LEFT)) {
			GroupSelection.getInstance().toggleSelection(this.object2D);
		}
		long newClickDate = System.currentTimeMillis();
		if (object2D != null && object2D.getWorldObject() != null && button == Input.Buttons.LEFT) {

			if (newClickDate - lastClickDate < 300) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {

						MesureWidow window = MesureWidow.getInstance();
						window.setObject2d(object2D);

						window.show();
					}
				});
			} else {
				if ( object2D.getWorldObject() instanceof KitchenElement
						&& ((KitchenElement) object2D.getWorldObject()).getDesignObject() instanceof DesignObject3D) {
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							GdxPart.setSelectedElement((Space3D) ((KitchenElement) object2D.getWorldObject()).getDesignObject());

						}
					});
				}
				//
				object2D.setOldRotation(object2D.getWorldObject().getRotation());
				object2D.setOldPosition(object2D.getWorldObject().getRealWorldPosition());
				object2D.setOldDimention(object2D.getWorldObject().getObjectDimention());

			}
		}
		if (object2D != null && object2D.getWorldObject() != null && button == Input.Buttons.RIGHT) {
			if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
				SurfaceController controller = ((SurfaceController) ((AbstractScreen) Scene.game.getScreen())
						.getController());
				if (controller.getReference() == object2D) {
					controller.setReference(null);
				} else {
					controller.setReference(object2D);
				}
			}

		}

		lastClickDate = newClickDate;

		return true;
	}
}
