package dressing.mathutils;

import java.util.ArrayList;
import com.badlogic.gdx.math.Vector2;

public class EarClipper {

	
	//triangulate a polygon without hole
	public static ArrayList<Triangle> triangulate(ArrayList<Vector2> vertices) {
		ArrayList<Triangle> ears = new ArrayList<Triangle>();
		ArrayList<Vector2> verticesCpy = new ArrayList<Vector2>();
		verticesCpy.addAll(vertices);
		MathUtilities.setWinding(verticesCpy, 1);
		earClip(verticesCpy, ears);
		return ears;
	}

	//triangulate polygon with hole
	//vertices must be supplied in cw directions while hole vertices must be given in ccw direction
	public static ArrayList<Triangle> triangulate(ArrayList<Vector2> polygonVertices, ArrayList<Vector2> holeVertices) {
		MathUtilities.setWinding(polygonVertices, 1);
		ArrayList<Vector2> vertices = new ArrayList<>();
		if(!holeVertices.isEmpty()) {
			MathUtilities.setWinding(holeVertices, -1);
			Vector2[] cut = findMutuallyVisibleVertices(polygonVertices, holeVertices);
			for (int i = 0; i <= polygonVertices.indexOf(cut[1]); i++) {
				vertices.add(polygonVertices.get(i));
			}
			int index = holeVertices.indexOf(cut[0]);
			for (int i = 0; i < holeVertices.size(); i++) {
				vertices.add(holeVertices.get(index));
				index++;
				index = index % holeVertices.size();
			}
			vertices.add(cut[0]);
			for (int i = polygonVertices.indexOf(cut[1]); i < polygonVertices.size(); i++) {
				vertices.add(polygonVertices.get(i));
			}
		}
		else {
			vertices.addAll(polygonVertices);
		}
		return triangulate(vertices);

	}

	public static void earClip(ArrayList<Vector2> vertices, ArrayList<Triangle> ears) {
		if (vertices.size() > 2) {
			Vector2 earVertex = null;
			for (Vector2 vertex : vertices) {
				earVertex = null;
				if (isAnEar(vertex, vertices)) {
					int index = vertices.indexOf(vertex);
					int previousIndex = (index - 1) % vertices.size();
					if (previousIndex < 0)
						previousIndex += vertices.size();
					Vector2 previousVertex = vertices.get(previousIndex);
					Vector2 nextVertex = vertices.get((index + 1) % vertices.size());
					Triangle triangle = new Triangle(vertex, nextVertex, previousVertex);
					ears.add(triangle);
					earVertex = vertex;
					break;
				}
			}
			if (earVertex != null) {
				vertices.remove(earVertex);
				earClip(vertices, ears);
			}
		}
	}

	public static boolean isAnEar(Vector2 vertex, ArrayList<Vector2> polygonVertices) {
		int index = polygonVertices.indexOf(vertex);
		if (index >= 0) {
			int previousIndex = (index - 1) % polygonVertices.size();
			if (previousIndex < 0)
				previousIndex += polygonVertices.size();
			int nextIndex = (index + 1) % polygonVertices.size();
			Vector2 vcp = polygonVertices.get(previousIndex).cpy().sub(vertex);
			Vector2 vcn = polygonVertices.get(nextIndex).cpy().sub(vertex);
			Vector2 vo = vcp.cpy().add(vcn);
			Vector2 vn = vcp.cpy().rotate(90).add(vcn.cpy().rotate(-90));
			boolean outerAngle = false;
			if(vo.dot(vn) > 0)
				outerAngle = true;
			float angle = vcp.angle(vcn);
			if ( outerAngle && angle <= 180)
				return false;
//			if(angle > 0)
//				return false;
			Triangle triangle = new Triangle(vertex, polygonVertices.get(previousIndex),
					polygonVertices.get(nextIndex));
			for (Vector2 vertexX : polygonVertices) {
				if (vertexX == vertex || vertexX == polygonVertices.get(previousIndex)
						|| vertexX == polygonVertices.get(nextIndex))
					continue;
				if (triangle.contains(vertexX))
					return false;
			}
			return true;
		}
		return false;
	}

	public static Vector2[] findMutuallyVisibleVertices(ArrayList<Vector2> outerPoly, ArrayList<Vector2> innerPoly) {
		Vector2[] mutuallyVisibleVertices = null;
		ArrayList<Edge> edges = new ArrayList<>();
		for (int i = 0; i < outerPoly.size(); i++) {
			int nextIndex = (i + 1) % outerPoly.size();
			edges.add(new Edge(outerPoly.get(i), outerPoly.get(nextIndex)));
		}
		for (int i = 0; i < innerPoly.size(); i++) {
			int nextIndex = (i + 1) % innerPoly.size();
			edges.add(new Edge(innerPoly.get(i), innerPoly.get(nextIndex)));
		}
		for (Vector2 innerVertex : innerPoly) {
			boolean terminate = false;
			for (Vector2 outerVertex : outerPoly) {
				Edge edge = new Edge(innerVertex, outerVertex);
				boolean mutuallyVisible = true;
				for (Edge edgeX : edges) {
					Vector2 intersectionpoint = MathUtilities.getIntersectionPoint(edge, edgeX);
					if (edgeX.getV0().epsilonEquals(intersectionpoint, 0.01f)
							|| edgeX.getV1().epsilonEquals(intersectionpoint, 0.01f))
						continue;
					if (edgeX.contains(intersectionpoint) && edge.contains(intersectionpoint)) {
						mutuallyVisible = false;
						break;
					}
				}
				if (mutuallyVisible) {
					mutuallyVisibleVertices = new Vector2[] { innerVertex, outerVertex };
					terminate = true;
					break;
				}
			}
			if (terminate)
				break;
		}
		return mutuallyVisibleVertices;
	}
}
