package api.mep;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.jogamp.vecmath.Vector2f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import com.badlogic.gdx.math.Vector3;
import com.sandmonkey.ttf_renderer.api.FreeTypeFont;
import com.sandmonkey.ttf_renderer.api.TextRenderer;

import api.backend.ApplicationContext;
import api.events.CustomEvent;
import api.events.EventBus;
import api.events.EventType;
import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.Shader;
import api.graphics.geometry.ShapeDrawer;
import api.input.InputMultiplexer;
import api.input.KeyboardEventHandler;
import api.input.MouseEventHandler;
import api.provider.FontProvider;

public class MeasureTaker implements  MouseEventHandler, KeyboardEventHandler, IDrawable{

	private Vector3f v0;
	private Vector3f v1;
	private static ShapeDrawer drawer;
	private static TextRenderer text;
	
	static {
		drawer = new ShapeDrawer();
		drawer.prepare();
		text = new TextRenderer();
		text.create();
	}

	public MeasureTaker() {}
	
	@Override
	public boolean handle(Event event) {
		if(!MouseEventHandler.super.handle(event))
			return KeyboardEventHandler.super.handle(event);
		return true;
	}
	
	public void end() {
		InputMultiplexer.getInstance().removeEventHandler(this);
		this.v0 = null;
		this.v1 = null;
		EventBus.getInstance().notify(new CustomEvent(EventType.REVOKE_RULER, null));
	}
	
	@Override
	public void draw(Shader shader, Camera camera) {
		if(v0 != null && v1!= null) {
			drawer.begin(camera);
			drawer.drawLines(new Vector3f[] {v0, v1}, 6, new Vector3f(1,0,0), new Matrix4f());
			drawer.end();
			String value = String.format("%.0f", v0.distance(v1) * 1000);
			float[] vp = ApplicationContext.getViewport();
			Vector3f screen0 = camera.project(v0, vp);
			Vector3f screen1 = camera.project(v1, vp);
			Vector3f dir = new Vector3f(screen1).sub(screen0).normalize();
			Vector3f nor = new Vector3f();
			dir.rotateZ((float) Math.toRadians(90), nor);
			nor.mul(10);
			
			Vector2f v = new Vector2f(screen1.x - screen0.x, screen1.y - screen0.y);
			v.normalize();
   		    float rotation = (float) Math.toDegrees(Math.atan2(v.y, v.x));
//   		    if(rotation < 0)
//   		    	rotation += 180;
			Vector3f center = screen0.add(screen1).mul(0.5f).add(nor);
			text.render(FontProvider.getProvider().getBoldFont(), value, center.x, center.y, 1, rotation, new Vector3f(0,0,1));
		}
	}

	@Override
	public void drawVertices(Camera camera) {
		
	}

	@Override
	public void drawSilhouette(Camera camera) {
		
	}

	@Override
	public boolean mouseDoubleClick(MouseEvent e) {
		return false;
	}

	@Override
	public boolean mouseDown(MouseEvent e) {
		ObjectSelector.getSelector().mouseDown(e);
		var selection = ObjectSelector.getSelector().getSelection();
		if(selection instanceof Vector3f) {
			Vector3f point = (Vector3f) selection;
			if(v0 == null) {
				v0 = point;
			}else{
				v1 = point;
			}
		}
		return false;
	}

	@Override
	public boolean mouseUp(MouseEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean mouseMove(MouseEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean mouseScrolled(MouseEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean mouseDragged(MouseEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyPressed(KeyEvent e) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean keyReleased(KeyEvent e) {
		if(e.character == SWT.ESC)
			end();
		return false;
	}

}
