	
package model.dressing.creator.srctcase;
import org.junit.Test;
import static org.junit.Assert.*;

import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import model.dressing.CommonDressing;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Separator;

public class DressingCreatorTest extends Checks{

	@Test
	public void test_create_0() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_1() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_2() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_3() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_4() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_5() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_6() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_7() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_8() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_9() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_10() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_11() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_12() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_13() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_14() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_15() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_16() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_17() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_18() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_19() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_20() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_21() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_22() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_23() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_24() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_25() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_26() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_27() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_28() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_29() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_30() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_31() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_32() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_33() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_34() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_35() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_36() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_37() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_38() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_39() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_40() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_41() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_42() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_43() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_44() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_45() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_46() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_47() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_48() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_49() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_50() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 1;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_51() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_52() {
    	Boolean withporte = true;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_53() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_54() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = false;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = false;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_55() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.COLISSANT;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_L;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 2;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSEXTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = false;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_56() {
    	Boolean withporte = false;
		drcreator.setWithporte(withporte);
                        
    	PortType porttype = PortType.FRANCAISE2V;
		drcreator.setPorttype(porttype);
                        
    	CaissonMontageType caissonMontageType = CaissonMontageType.CAISSON_MONTAGE_I;
		drcreator.setCaissonMontageType(caissonMontageType);
                        
    	int caissoncount = 3;
		drcreator.setCaissoncount(caissoncount);
                        
    	DosType dostype = DosType.DOSINTERIEUR;
		drcreator.setDostype(dostype);
                        
    	Boolean withseprator = true;
		drcreator.setWithseprator(withseprator);
                        
    	Boolean sepratortransversal = true;
		drcreator.setSepratortransversal(sepratortransversal);
                        
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		drcreator.setSeprationaxe(seprationaxe);
                        
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		drcreator.setSepPosRefType(sepPosRefType);
                        
    	Boolean separatorisometrique = true;
		drcreator.setSeparatorisometrique(separatorisometrique);
                        
    
		try {
		drcreator.create();

		checkCaissonTypes(drcreator);
		checkCaissonPieceTypes(drcreator);
		checkCaissonDosTypes(drcreator);
		CheckSeparatorDos(drcreator);
		CheckCaissonSeparator(drcreator);
		checkCaissonMesuresPieces(drcreator);
		checkCaissonColissant(drcreator);
		checkCaissonDimensionPiece(drcreator);
		CheckCaissonPortetypes(drcreator);
		CheckPositionsPieceCaisson(drcreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}
}
