package model.piece2dcreator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;
import utils.ParametersUtils;

public class Checks extends CommonPiece2dParent {

	protected void checkPieceTypes(Piece2DCreator piece2dCreator) {
		checkCanHold(piece2dCreator.getParent());
		assertNotNull(piece2dCreator.getPiece2DInstance());
		assertEquals(Separator.class, piece2dCreator.getPiece2DInstance().getClass());
		assertEquals(caisson.getBasematerial(), piece2dCreator.getPiece2DInstance().getBasematerial());
		assertEquals(caisson.getBackmaterial(), piece2dCreator.getPiece2DInstance().getBackmaterial());
		assertEquals(caisson, ((Piece2D) piece2dCreator.getPiece2DInstance()).getParentdesign());

	}

	protected void checkCaissonDimensionPiece(Piece2DCreator piece2dCreator) {
		// tester les dimension largeur et hauteur du seperateur dans le caisson
		if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
			if (piece2dCreator.getPiece2DInstance().getHauteurext() > piece2dCreator.getPiece2DInstance()
					.getProfondeurext()) {
				assertEquals(piece2dCreator.getPiece2DInstance().getHauteurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getProfondeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
			} else {
				assertEquals(piece2dCreator.getPiece2DInstance().getHauteurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getProfondeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
			}
		} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
			if (piece2dCreator.getPiece2DInstance().getLongeurext() > piece2dCreator.getPiece2DInstance()
					.getProfondeurext()) {
				assertEquals(piece2dCreator.getPiece2DInstance().getLongeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getProfondeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
			} else {
				assertEquals(piece2dCreator.getPiece2DInstance().getLongeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getProfondeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
			}
		} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
			if (piece2dCreator.getPiece2DInstance().getLongeurext() > piece2dCreator.getPiece2DInstance()
					.getHauteurext()) {
				assertEquals(piece2dCreator.getPiece2DInstance().getLongeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getHauteurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
			} else {
				assertEquals(piece2dCreator.getPiece2DInstance().getLongeurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceH(), ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getPiece2DInstance().getHauteurext(),
						((Piece2D) piece2dCreator.getPiece2DInstance()).getPieceL(), ParametersUtils.epsilon);
			}
		}
		// tester les dimension largeur et hauteur du dos dans le separator dans le
		// caisson
		if (((Piece2D) piece2dCreator.getPiece2DInstance()).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
			assertNotNull(((Separator) piece2dCreator.getPiece2DInstance()).getChilds());
			for (DesignObject3D space : ((Separator) piece2dCreator.getPiece2DInstance()).getChilds()) {
				assertNotNull(space.getChilds());
				for (DesignObject3D piece2d : space.getChilds()) {
					if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						if (piece2d.getHauteurext() > piece2d.getLongeurext()) {
							assertEquals(piece2d.getHauteurext(), ((Piece2D) piece2d).getPieceL(),
									ParametersUtils.epsilon);
							assertEquals(piece2d.getLongeurext(), ((Piece2D) piece2d).getPieceH(),
									ParametersUtils.epsilon);
						} else {
							assertEquals(piece2d.getHauteurext(), ((Piece2D) piece2d).getPieceH(),
									ParametersUtils.epsilon);
							assertEquals(piece2d.getLongeurext(), ((Piece2D) piece2d).getPieceL(),
									ParametersUtils.epsilon);
						}
					}

				}
			}
		}
	}

	protected void CheckPositionsPieceCaisson(Piece2DCreator piece2dCreator) {
		// tester les positions des dos dans le separator dans le caisson

		if (((Piece2D) piece2dCreator.getPiece2DInstance()).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
			assertNotNull(((Separator) piece2dCreator.getPiece2DInstance()).getChilds());
			for (DesignObject3D space : ((Separator) piece2dCreator.getPiece2DInstance()).getChilds()) {
				assertNotNull(space.getChilds());

				for (DesignObject3D piece2d : space.getChilds()) {

					if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
							if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
								fail("une dos dans un zone de type ZONE_HAUT dans un separateur de sepaxe egale a Z est non supporter");
							}
						}
						assertEquals(ParametersUtils.dosRainurePositionOffset, piece2d.getZpos(),
								ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece2d.getYpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece2d.getXpos(), ParametersUtils.epsilon);

					}

				}
			}
		}
	}

	protected void CheckSeparatorDos(Piece2DCreator piece2dCreator) {
		// ce bloc tester les dimention (longeur,lardeur,profendeur) et les
		// position(x,y,z) des dos dans le separator univers
		for (DesignObject3D space : ((Separator) piece2dCreator.getPiece2DInstance()).getChilds()) {

			for (DesignObject3D piece2d : space.getChilds()) {
				// verifier que l'axe de separation est diffirent de Z et si le cas le zone doit
				// different du zoneHaut
				if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						fail("le dos dans un space3D de type ZONE_HAut dans un sep avec sepaxe Z est non supporter");
					}
				}
				if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
					assertEquals(space.getHauteurint() + (2 * ParametersUtils.dosRainureProf), piece2d.getHauteurext(),
							ParametersUtils.epsilon);
					assertEquals(space.getLongeurint() + (2 * ParametersUtils.dosRainureProf), piece2d.getLongeurext(),
							ParametersUtils.epsilon);
					assertEquals(caisson.getBackmaterial().getEpaisseur(), piece2d.getProfondeurext(),
							ParametersUtils.epsilon);
					assertEquals(ParametersUtils.dosRainurePositionOffset, piece2d.getZpos(), ParametersUtils.epsilon);
					assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
							piece2d.getXpos(), ParametersUtils.epsilon);
					assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
							piece2d.getYpos(), ParametersUtils.epsilon);
				}
			}

		}

	}

	protected void CheckCaissonSeparator(Piece2DCreator piece2dCreator) {
		CheckCaissonSeparatorDimension(piece2dCreator);
		CheckCaissonSeparatorPositions(piece2dCreator);
		CheckCaissonSeparatorSpacesDimension(piece2dCreator);
		//
		if (((Piece2D) piece2dCreator.getPiece2DInstance()).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {

			assertEquals(((Separator) piece2dCreator.getPiece2DInstance()).getSepaxe(),
					piece2dCreator.getSeprationaxe());
			assertEquals(((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial(),
					piece2dCreator.getBasematerial());
			assertEquals(Zone3DType.ZONEHAUT,
					((Separator) piece2dCreator.getPiece2DInstance()).getLefttopchild().getZonetype());
			assertEquals(Zone3DType.ZONEBAS,
					((Separator) piece2dCreator.getPiece2DInstance()).getRightdownchild().getZonetype());
		}
	}

	protected void CheckCaissonSeparatorSpacesDimension(Piece2DCreator piece2dCreator) {

		// tester le profondeur des Spaces dans le separateur
		assertEquals(2, ((Separator) piece2dCreator.getPiece2DInstance()).getChilds().size());
		assertNotNull(((Separator) piece2dCreator.getPiece2DInstance()).getLefttopchild());
		assertNotNull(((Separator) piece2dCreator.getPiece2DInstance()).getRightdownchild());
		assertEquals(Space3D.class, ((Separator) piece2dCreator.getPiece2DInstance()).getLefttopchild().getClass());
		assertEquals(Space3D.class, ((Separator) piece2dCreator.getPiece2DInstance()).getRightdownchild().getClass());
		assertEquals(Zone3DType.ZONEHAUT,
				((Separator) piece2dCreator.getPiece2DInstance()).getLefttopchild().getZonetype());
		assertEquals(Zone3DType.ZONEBAS,
				((Separator) piece2dCreator.getPiece2DInstance()).getRightdownchild().getZonetype());
		for (DesignObject3D space : ((Separator) piece2dCreator.getPiece2DInstance()).getChilds()) {
			assertEquals(Space3D.class, space.getClass());
			assertNotNull(space);
			// new
			if (piece2dCreator.getPorttype().equals(PortType.COLISSANT)) {
				if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
					assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
							space.getProfondeurint(), ParametersUtils.epsilon);
					assertEquals(caisson.getHauteurint(), space.getHauteurint(), ParametersUtils.epsilon);
					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								piece2dCreator.getPiece2DInstance().getXpos()
										- caisson.getBasematerial().getEpaisseur(),
								space.getLongeurint(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								caisson.getLongeurint()
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()
										- piece2dCreator.getPiece2DInstance().getXpos()
										+ caisson.getBasematerial().getEpaisseur(),
								space.getLongeurint(), ParametersUtils.epsilon);
					}

				} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
					assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
							space.getProfondeurint(), ParametersUtils.epsilon);
					assertEquals(caisson.getLongeurint(), space.getLongeurint(), ParametersUtils.epsilon);

					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								caisson.getHauteurint() - piece2dCreator.getPiece2DInstance().getYpos()
										- piece2dCreator.getPiece2DInstance().getBasematerial().getEpaisseur()
										+ caisson.getBasematerial().getEpaisseur(),
								space.getHauteurint(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								piece2dCreator.getPiece2DInstance().getYpos()
										- caisson.getBasematerial().getEpaisseur(),
								space.getHauteurint(), ParametersUtils.epsilon);
					}

				} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
					assertEquals(caisson.getLongeurint(), space.getLongeurint(), ParametersUtils.epsilon);
					assertEquals(caisson.getHauteurint(), space.getHauteurint(), ParametersUtils.epsilon);
					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								caisson.getProfondeurext() - piece2dCreator.getPiece2DInstance().getZpos()
										- piece2dCreator.getPiece2DInstance().getBasematerial().getEpaisseur()
										- ParametersUtils.retraitcolissant,
								space.getProfondeurext(), ParametersUtils.epsilon);
					} else {
						assertEquals(piece2dCreator.getPiece2DInstance().getZpos(), space.getProfondeurext(),
								ParametersUtils.epsilon);
					}

				}
			} else if (piece2dCreator.getPorttype().equals(PortType.FRANCAISE)
					|| piece2dCreator.getPorttype().equals(PortType.FRANCAISE2V)) {
				if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
					if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						assertEquals(caisson.getProfondeurext() - piece2dCreator.getSepretraitderiere(), space.getProfondeurext(), ParametersUtils.epsilon);
					}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
						assertEquals(caisson.getProfondeurext() -piece2dCreator.getSepretraitderiere() -ParametersUtils.dosRainurePositionOffset
								-ParametersUtils.jeurainuredos-caisson.getBackmaterial().getEpaisseur()
								, space.getProfondeurext(), ParametersUtils.epsilon);
					}
					assertEquals(caisson.getHauteurint(), space.getHauteurint(), ParametersUtils.epsilon);
					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								piece2dCreator.getPiece2DInstance().getXpos()
										- caisson.getBasematerial().getEpaisseur(),
								space.getLongeurint(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								caisson.getLongeurint()
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()
										- piece2dCreator.getPiece2DInstance().getXpos()
										+ caisson.getBasematerial().getEpaisseur(),
								space.getLongeurint(), ParametersUtils.epsilon);
					}
				} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
					if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						assertEquals(caisson.getProfondeurext()- piece2dCreator.getSepretraitderiere(), space.getProfondeurext(), ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurint(), space.getLongeurint(), ParametersUtils.epsilon);	
					}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
						assertEquals(caisson.getProfondeurext()- piece2dCreator.getSepretraitderiere() -ParametersUtils.dosRainurePositionOffset
								-ParametersUtils.jeurainuredos-caisson.getBackmaterial().getEpaisseur()
								, space.getProfondeurext(), ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurint(), space.getLongeurint(), ParametersUtils.epsilon);	

					}


					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								caisson.getHauteurint() - piece2dCreator.getPiece2DInstance().getYpos()
										- piece2dCreator.getPiece2DInstance().getBasematerial().getEpaisseur()
										+ caisson.getBasematerial().getEpaisseur(),
								space.getHauteurint(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								piece2dCreator.getPiece2DInstance().getYpos()
										- caisson.getBasematerial().getEpaisseur(),
								space.getHauteurint(), ParametersUtils.epsilon);
					}

				} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
					assertEquals(caisson.getLongeurint(), space.getLongeurint(), ParametersUtils.epsilon);
					assertEquals(caisson.getHauteurint(), space.getHauteurint(), ParametersUtils.epsilon);
					if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
						assertEquals(
								caisson.getProfondeurext() - piece2dCreator.getPiece2DInstance().getZpos()
										- piece2dCreator.getPiece2DInstance().getBasematerial().getEpaisseur(),
								space.getProfondeurext(), ParametersUtils.epsilon);
					} else {
						if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
							assertEquals(piece2dCreator.getPiece2DInstance().getZpos(), space.getProfondeurext(),
									ParametersUtils.epsilon);
						}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
							assertEquals(piece2dCreator.getPiece2DInstance().getZpos()
									-ParametersUtils.dosRainurePositionOffset-ParametersUtils.jeurainuredos
									-caisson.getBackmaterial().getEpaisseur(), space.getProfondeurext(),
									ParametersUtils.epsilon);
						}
					
					}

				}
			}
		}
		//

	}

	protected void CheckCaissonSeparatorDimension(Piece2DCreator piece2dCreator) {
		// tester les dimension du la separateur
		if (piece2dCreator.getPorttype().equals(PortType.COLISSANT)) {
			if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {

				assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
						piece2dCreator.getPiece2DInstance().getProfondeurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);
			} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {

				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
						piece2dCreator.getPiece2DInstance().getProfondeurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);

			} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
				assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getProfondeurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);

			}
		} else if (piece2dCreator.getPorttype().equals(PortType.FRANCAISE)
				|| piece2dCreator.getPorttype().equals(PortType.FRANCAISE2V)) {
			if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {

				assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);

				if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
					assertEquals(caisson.getProfondeurext() - piece2dCreator.getSepRetrait() - piece2dCreator.getSepretraitderiere()
							, piece2dCreator.getPiece2DInstance().getProfondeurext(),
							ParametersUtils.epsilon);
				}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
					assertEquals(caisson.getProfondeurext()- piece2dCreator.getSepretraitderiere() - piece2dCreator.getSepRetrait() - ParametersUtils.dosRainurePositionOffset
							-ParametersUtils.jeurainuredos-caisson.getBackmaterial().getEpaisseur()
							, piece2dCreator.getPiece2DInstance().getProfondeurext(), ParametersUtils.epsilon);

				}
				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);
			} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);
				if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
					assertEquals(caisson.getProfondeurint()-piece2dCreator.getSepRetrait()-piece2dCreator.getSepretraitderiere(), piece2dCreator.getPiece2DInstance().getProfondeurext(),
							ParametersUtils.epsilon);
				}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
					assertEquals(caisson.getProfondeurint()-piece2dCreator.getSepRetrait()-piece2dCreator.getSepretraitderiere()-ParametersUtils.dosRainurePositionOffset-ParametersUtils.jeurainuredos
							-caisson.getBackmaterial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getProfondeurext(),
							ParametersUtils.epsilon);
				}
			
				assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);

			} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
				assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getHauteurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getProfondeurext(), ParametersUtils.epsilon);
				assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getLongeurext(), ParametersUtils.epsilon);

			}
		}

	}

	protected void CheckCaissonSeparatorPositions(Piece2DCreator piece2dCreator) {
		// tester les positions du separateur dans le caisson
		if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
			
			if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
				assertEquals(piece2dCreator.getSepretraitderiere() , piece2dCreator.getPiece2DInstance().getZpos(),
						ParametersUtils.epsilon);
			}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
				assertEquals(caisson.getProfondeurint()-piece2dCreator.getSepRetrait()-piece2dCreator.getSepretraitderiere()-ParametersUtils.dosRainurePositionOffset-ParametersUtils.jeurainuredos
						-caisson.getBackmaterial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getProfondeurext(),
						ParametersUtils.epsilon);
				assertEquals(piece2dCreator.getSepretraitderiere()+ParametersUtils.dosRainurePositionOffset+ParametersUtils.jeurainuredos
						+caisson.getBackmaterial().getEpaisseur() , piece2dCreator.getPiece2DInstance().getZpos(),
						ParametersUtils.epsilon);
			}
			assertEquals(caisson.getBasematerial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getYpos(),
					ParametersUtils.epsilon);
			if (piece2dCreator.getIsSepIsometrique()) {
				assertEquals(
						(caisson.getLongeurint()
								- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()) / 2
								+ caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getXpos(), ParametersUtils.epsilon);
			} else {
				if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.FIX)) {
					if (piece2dCreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
						assertEquals(caisson.getBasematerial().getEpaisseur() + piece2dCreator.getSeparationposition(),
								piece2dCreator.getPiece2DInstance().getXpos(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								caisson.getLongeurint() + caisson.getBasematerial().getEpaisseur()
										- piece2dCreator.getSeparationposition()
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur(),
								piece2dCreator.getPiece2DInstance().getXpos(), ParametersUtils.epsilon);
					}
				}
				

			}

			if (piece2dCreator.getPiece2DInstance().getZpos() > caisson.getLongeurext()) {
				fail("le position du separateur sur l'axe X doit inferieur a la Longeur du caisson ");
			}
		} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
			assertEquals(caisson.getBasematerial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getXpos(),
					ParametersUtils.epsilon);

			if (piece2dCreator.getIsSepIsometrique()) {
				assertEquals(
						(caisson.getHauteurint()
								- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()) / 2
								+ caisson.getBasematerial().getEpaisseur(),
						piece2dCreator.getPiece2DInstance().getYpos(), ParametersUtils.epsilon);
			} else if (!piece2dCreator.getIsSepIsometrique()){
				if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.FIX)) {
					if (piece2dCreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
						assertEquals(caisson.getBasematerial().getEpaisseur() + piece2dCreator.getSeparationposition(),
								piece2dCreator.getPiece2DInstance().getYpos(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								caisson.getHauteurint() + caisson.getBasematerial().getEpaisseur()
										- piece2dCreator.getSeparationposition()
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur(),
								piece2dCreator.getPiece2DInstance().getYpos(), ParametersUtils.epsilon);
					}
				}else if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.POURCENT)) {
					if (piece2dCreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
						assertEquals(caisson.getBasematerial().getEpaisseur() + 
								(((caisson.getHauteurint() - piece2dCreator.getMaterial().getEpaisseur())*piece2dCreator.getSeparationposition())/100),
								piece2dCreator.getPiece2DInstance().getYpos(), ParametersUtils.epsilon);
					} else {
						assertEquals(
								caisson.getHauteurint() + caisson.getBasematerial().getEpaisseur()
										- (((caisson.getHauteurint() - piece2dCreator.getMaterial().getEpaisseur())*piece2dCreator.getSeparationposition())/100)
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur(),
								piece2dCreator.getPiece2DInstance().getYpos(), ParametersUtils.epsilon);
					}
				}
				

			}
		
			if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
				assertEquals(piece2dCreator.getSepretraitderiere(), piece2dCreator.getPiece2DInstance().getZpos(),
						ParametersUtils.epsilon);
			}else if(piece2dCreator.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
				assertEquals(piece2dCreator.getSepretraitderiere()+ParametersUtils.dosRainurePositionOffset+ParametersUtils.jeurainuredos
						+caisson.getBackmaterial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getZpos(),
						ParametersUtils.epsilon);
			}
			if (piece2dCreator.getPiece2DInstance().getYpos() > caisson.getHauteurext()) {
				fail("le position du separateur sur l'axe Y doit inferieur a la Hauteur du caisson ");
			}
		} else if (piece2dCreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
			assertEquals(caisson.getBasematerial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getXpos(),
					ParametersUtils.epsilon);
			assertEquals(caisson.getBasematerial().getEpaisseur(), piece2dCreator.getPiece2DInstance().getYpos(),
					ParametersUtils.epsilon);
			if (piece2dCreator.getIsSepIsometrique()) {
				assertEquals(
						(caisson.getProfondeurint()
								- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()) / 2,
						piece2dCreator.getPiece2DInstance().getZpos(), ParametersUtils.epsilon);
			} else {
				if (piece2dCreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
					if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.FIX)) {
						assertEquals(piece2dCreator.getSeparationposition(), piece2dCreator.getPiece2DInstance().getZpos(),
								ParametersUtils.epsilon);
					}else if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.POURCENT)) 
					{
						assertEquals(((caisson.getProfondeurint() -piece2dCreator.getMaterial().getEpaisseur())*piece2dCreator.getSeparationposition())/100, piece2dCreator.getPiece2DInstance().getZpos(),
								ParametersUtils.epsilon);
					}


				} else {
					
					if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.FIX)) {
						assertEquals(
								caisson.getProfondeurint() - piece2dCreator.getSeparationposition()
										- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur(),
								piece2dCreator.getPiece2DInstance().getZpos(), ParametersUtils.epsilon);
					}else if(piece2dCreator.getPositionCalculationType().equals(PositionCalculationType.POURCENT)) 
					{
						assertEquals(caisson.getProfondeurint()- ((Piece2D) piece2dCreator.getPiece2DInstance()).getMaterial().getEpaisseur()
								- ((caisson.getProfondeurint() -piece2dCreator.getMaterial().getEpaisseur())*piece2dCreator.getSeparationposition())/100
								, piece2dCreator.getPiece2DInstance().getZpos(),
								ParametersUtils.epsilon);
					}
				}

			}
			if (piece2dCreator.getPorttype().equals(PortType.COLISSANT)) {
				if (piece2dCreator.getPiece2DInstance()
						.getZpos() > (caisson.getProfondeurext() - ParametersUtils.retraitcolissant)) {
					fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson avec la soustraction du retrait colissant");
				}
			} else {
				if (piece2dCreator.getPiece2DInstance().getZpos() > caisson.getProfondeurext()) {
					fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson ");
				}
			}
		}

	}

	/**
	 * tester si le parent able to hold the child
	 * 
	 */
	protected void checkCanHold(DesignObject3D parent) {
		for (DesignObject3D child : parent.getChilds()) {
			assertEquals(true, parent.canHold(child));
			checkCanHold(child);
		}
	}
}
