package supercad.persistence.databinding;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import supercad.structures.Node;
import supercad.structures.NodeIterator;

public class ElementNode implements Node {

	private Class type;
	private Object value;
	private String name;
	private Field field;						//the field this node represents in the parent node value
	private ElementNode parent;
	private ArrayList<ElementNode> children = new ArrayList<ElementNode>();
	
	
	
	public ElementNode() {}
	
	public ElementNode(String name) {
		this.name = name;
	}
		
	@Override
	public Iterator<Node> iterator() {
		return new NodeIterator(this);
	}
	
	public void addChild(ElementNode node, Boolean updateOtherSide) {
		children.add(node);
		if(updateOtherSide)
			node.setParent(this, false);
	}
	
	
	
	

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Class getType() {
		return type;
	}

	public void setType(Class type) {
		this.type = type;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
		setType(value.getClass());
	}


	public ArrayList<ElementNode> getChildren() {
		return children;
	}

	public ElementNode getParent() {
		return parent;
	}

	public void setParent(ElementNode parent, Boolean updateOtherSide) {
		this.parent = parent;
		if(updateOtherSide)
			parent.addChild(this, false);
	}

	public void setChildren(ArrayList<ElementNode> children) {
		this.children = children;
	}
	
	


	@Override
	public String toString() {
		return "ElementNode [type=" + type + ", value=" + value + ", name=" + name + ", children=" + children + "]";
	}


}
