package reporting.htmlReporting.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class HtmlAttribute implements HtmlNode{
	private String name="";
	List<String> segments=new ArrayList<String>();
	char seperator=' ';
	
	public HtmlAttribute() {
		super();
	}
	
	public HtmlAttribute(String name, char seperator) {
		super();
		this.name = name;
		this.seperator = seperator;
	}

	public List<String> getSegments() {
		return segments;
	}
	public void setSegments(List<String> segments) {
		this.segments = segments;
	}
	public void setSegment(String segment) {
		getSegments().clear();
		getSegments().add(segment);
	}
	public char getSeperator() {
		return seperator;
	}
	public void setSeperator(char seperator) {
		this.seperator = seperator;
	}
	@Override
	public String getContent() {
		StringBuilder sb=new StringBuilder();
		if(!segments.isEmpty())
		{					
			sb.append(" ");
			sb.append(getName());
			sb.append("=\"");	
			Iterator<String> it= segments.iterator();
			while(it.hasNext()) {
				String seg =it.next();
				sb.append(seg==null?"":getSegmentContent(seg));
				if(it.hasNext()) {
					sb.append(getSeperator());
				}
			}
			sb.append("\"");
		}
		
		return sb.toString();
	}
	protected String getSegmentContent(String seg) {
		return seg;
	}
	public void appendSegment(String segment) {
		getSegments().add(segment);
	}
	public void appendSegments(String... segment) {
		getSegments().addAll(Arrays.asList(segment));
	}
	@Override
	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}
	

}
