package geometry;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.MathUtilities;

public class ShapeBuilder {
	
	 public static  Arc buildCircle(Vector2 center, float radius, int segments){
	        int segs = (int) (5 * Math.PI * radius);
	        Vector2 pointer = new Vector2(radius,0);
	        ArrayList<Vector2> points = new ArrayList<Vector2>();
	        float angle = 360.0f/segs;
	        for(int i = 0; i < segs; i++){
	            pointer.rotate(-angle);
	            points.add(new Vector2(center).cpy().add(pointer));
	        }
	        Arc arc = new Arc(center, radius);
	        arc.setVertices(points);

	        return arc;
	    }
	    public static Arc buildCircle(Vector2 center, Vector2 v0, Vector2 v1){
	        float radius = v0.dst(center);
	        float angle = MathUtilities.signedAngle(v0.cpy().sub(center),v1.cpy().sub(center));
	        Gdx.app.debug("build arc method",Math.toDegrees(angle) +"");
	        int segs = (int) Math.abs((angle * radius/5));
	        Vector2 pointer = new Vector2(v0).sub(center);
	        Vector2 normal = new Vector2(-v1.cpy().sub(v0).y,v1.cpy().sub(v0).x);
	        ArrayList<Vector2> points = new ArrayList<Vector2>();
	        points.add(v0.cpy());
	        float step = angle/segs;
	        for(int i = 0; i < segs; i++){
	            pointer.rotateRad(step);
	            points.add(new Vector2(center).cpy().add(pointer));
	        }
	        points.add(v1.cpy());
	        Arc arc = new Arc(center, radius);
	        ArrayList<Vector2> flippedPoints = new ArrayList<>();
	        for(int i = points.size() - 1; i > -1 ; i--){
	            flippedPoints.add(points.get(i));
	        }
	        arc.setVertices(points);
	        return arc;
	    }
	    

	    public Arc buildArc(Vector2 center, float radius, int segments){
	        int segs = (int) (2 * Math.PI * radius/5);
	        Vector2 pointer = new Vector2(radius,0);
	        ArrayList<Vector2> points = new ArrayList<Vector2>();
	        float angle = 360.0f/segs;
	        for(int i = 0; i < segs; i++){
	            pointer.rotate(angle);
	            points.add(new Vector2(center).cpy().add(pointer));
	        }
	        Arc arc = new Arc(center, radius);
	        arc.setVertices(points);

	        return arc;
	    }
	    public ArrayList<Vector2> createQuadraticBezierCurve(Vector2 P0, Vector2 P1, Vector2 P2){
	        ArrayList<Vector2> points = new ArrayList<>();
	        float step = 0.02f;
	        int segs = (int) (1/step);
	        float t = 0;
	        for(int i = 0; i < segs; i++){
	            t += step;
	            Vector2 y = MathUtilities.bezierQuadratic(P0,P1,P2,t);
	            points.add(y);
	        }
	        return points;
	    }
	    
	    public static ArrayList<Vector3> getCircleVertices(Vector3 normal, float radius, int segments){
	        float angularStep = (float) ((Math.PI * 2) / segments);
	        Vector3 pointer = new Vector3(normal.y,normal.z,normal.x).crs(normal).nor().scl(radius);
	        ArrayList<Vector3> pointOnCircle = new ArrayList<Vector3>();
	        for(int i = 0; i < segments; i++){
	            float angle = (float) Math.toDegrees(angularStep * i);
	            pointOnCircle.add(pointer.cpy().rotate(normal, angle));
	        }
	        return pointOnCircle;
	    }

	    public static ArrayList<Vector3> rotateCircleVertices(ArrayList<Vector3> circle, Vector3 normal){
	        ArrayList<Vector3> rotatedPoints = new ArrayList<>();
	        Vector3 oldNormal = circle.get(2).cpy().sub(circle.get(0)).crs(circle.get(1).cpy().sub(circle.get(0))).nor();
	        normal.nor();
	        Vector3 crsProd = oldNormal.cpy().crs(normal);
	        float sinus = crsProd.len();
	        float cosinus = oldNormal.dot(normal);
	        float angle = (float) Math.toDegrees(Math.atan(sinus/cosinus));
	        if(angle > 1)
	            System.err.println(angle);
	        for(Vector3 circlePoint: circle){
	            rotatedPoints.add(circlePoint.cpy().rotate(crsProd, angle));
	        }
	        return rotatedPoints;
	    }

}
