package gdxapp.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

public class DirectionalLight  extends Light{
	
	 	Vector3 position;
	    Vector3 direction;
	    private transient Matrix4 pv;
	    private transient Texture depthMap;

	    public DirectionalLight() {
			super();
			this.position=new Vector3(0,0,0);
			this.direction=new Vector3(0,0,0);
		}

		public Vector3 getPosition() {
	        return position;
	    }

	    public void setPosition(Vector3 position) {
	        this.position = position;
	    }

	    public Vector3 getDirection() {
	        return direction.nor();
	    }

	    public void setDirection(Vector3 direction) {
	        this.direction = direction;
	    }

	    public Vector3 getIntensity() {
	        return intensity;
	    }

	    public void setIntensity(Vector3 intensity) {
	        this.intensity = intensity;
	    }


	    public Texture getDepthMap() {
	        return depthMap;
	    }

	    public void setDepthMap(Texture depthMap) {
	        this.depthMap = depthMap;
	    }
	    

	    public Camera getCamera(){
	        Matrix4 projection = new Matrix4().setToOrtho(-10,10,-10,10,1.0f,50f);
	        Matrix4 view = new Matrix4().setToLookAt(position, new Vector3(5,0,5), Vector3.Y);
	        this.pv = projection.mul(view);
	        Camera camera = new OrthographicCamera();
	        camera.combined.set(pv);
	        return camera;
	    }
		@Override
		public String toString() {
			return "DirectionalLight [direction=" + direction + "]";
		}
}
