package gdxapp.screens.modelviewer;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;

import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ScreenController;
import gdxapp.Commun.Tools3D;

public class ViewerScreen extends AbstractScreen {
	
	private static ViewerScreen screen = new ViewerScreen();
	private ViewerController controller;
	private Object renderable;
	private ModelInstance origin;
	private ModelInstance grid;
	
	
	
	private ArrayList<ModelInstance> instances;
	
	private ViewerScreen() {
		
		
		
		instances = new ArrayList<ModelInstance>();
		controller = new ViewerController();
		ModelBuilder modelBuilder = new ModelBuilder();
//		origin = new ModelInstance(modelBuilder.createXYZCoordinates(1, 
//				new Material(ColorAttribute.createDiffuse(Color.RED)), VertexAttributes.Usage.Position));
		origin = new ModelInstance(Tools3D.createCoordinateSystem());
		//origin.transform.set(transform1);
		grid = new ModelInstance(modelBuilder.createLineGrid(100, 100, 1, 1, new Material(ColorAttribute.createDiffuse(Color.WHITE)), VertexAttributes.Usage.Position));
	}

	@Override
	public void show() {
		float[] transform1 = new float[] {
				1, 0, 0, 0,
				0, 1, 0, 0,
				0, 0, 1, 0,
				0, 1, 0, 1
		};
		// TODO Auto-generated method stub
		Gdx.input.setInputProcessor(controller.getInputMultiplexer());
		//origin = new ModelInstance(Tools3D.createCoordinateSystem());
		//origin.transform.set(transform1);
		//origin.calculateTransforms();

	}

	@Override
	public void render(float delta) {
		 Gdx.gl20.glClearColor(0/255f, 0/255f,0/255f,1);
	     Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
	     Gdx.gl20.glBlendEquation(GL20.GL_SRC_ALPHA);
	     Gdx.gl20.glEnable(GL20.GL_BLEND);

	     controller.getCameraController().update();
	     controller.getBatch().begin(controller.getCamera());
	     controller.getBatch().render(grid);
	     controller.getBatch().render(origin);
	     for(ModelInstance instance: instances) {
	    	 controller.getBatch().render(instance);
	     }
	     controller.getBatch().end();
	}

	@Override
	public void resize(int width, int height) {
		// TODO Auto-generated method stub

	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub

	}

	@Override
	public void hide() {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	public static ViewerScreen getScreen() {
		return screen;
	}

	public static void setScreen(ViewerScreen screen) {
		ViewerScreen.screen = screen;
	}

	

	public void setController(ViewerController controller) {
		this.controller = controller;
	}

	public Object getRenderable() {
		return renderable;
	}

	public void setRenderable(Object renderable) {
		if(renderable != this.renderable) {
			this.renderable = renderable;
			controller.renderableChanged();
		}
	}

	public ArrayList<ModelInstance> getInstances() {
		return instances;
	}

	public void setInstances(ArrayList<ModelInstance> instances) {
		this.instances = instances;
	}

	@Override
	public ScreenController getController() {
		// TODO Auto-generated method stub
		return controller;
	}
	
}
