package dressing.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

import dressing.ui.util.NumberField;
import dressing.ui.util.TypeDefContentProvider;
import dressing.ui.util.TypeDefElementLabelProvider;
import param.MechanicPublicParam;
import param.TypeDefElement;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class PublicParamEditorComposite {

	private Spinner spinner;
	private Text text;
	private Button button;
	private ComboViewer comboViewer;
	private MechanicPublicParam param;
	private Map<MechanicPublicParam, PublicParamEditorComposite> dirtyParams;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 * @param dirtyParams 
	 */
	public PublicParamEditorComposite(Composite parent, int style,MechanicPublicParam param, Map<MechanicPublicParam, PublicParamEditorComposite> dirtyParams,boolean isshowlabel) {
//		super(parent, style);
//		setLayout(new GridLayout(2, false));
		this.dirtyParams=dirtyParams;
		int nbcol=2;
		if(!isshowlabel) {
			nbcol=1;
		}
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			
			if(isshowlabel) {
				Label lblName = new Label(parent, SWT.WRAP);
				lblName.setText(param.getUserlabel());
				GridData gd=new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
				gd.widthHint=150;
				lblName.setLayoutData(gd);
			}
			this.param=param;
			NumberField numberfield=new NumberField(parent, SWT.BORDER);
			text=numberfield.getText();
			text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			numberfield.setMaximum(100000000.0);
			numberfield.setContent(Double.valueOf(this.param.getDefaultvalue()));
//			spinner = new Spinner(parent, SWT.BORDER);
//			spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//			spinner.setMaximum(100000000);
//			spinner.setSelection();
			
			text.addModifyListener(new ModifyListener() {
				
				@Override
				public void modifyText(ModifyEvent e) {
					dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					
				}
			});
		}
		else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				button = new Button(parent, SWT.CHECK);
				button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, nbcol, 1));
				button.setSelection(Boolean.valueOf(param.getTypedefelement().getKey()));
				this.param=param;
				button.addSelectionListener(new SelectionListener() {
					
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					}
					
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
				button.setText(param.getUserlabel());
			}
			else {
				if(isshowlabel) {
					Label lblName = new Label(parent, SWT.WRAP);
					lblName.setText(param.getUserlabel());
					GridData gd=new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
					gd.widthHint=150;
					lblName.setLayoutData(gd);
				}
				
				this.param=param;
				comboViewer = new ComboViewer(parent, SWT.READ_ONLY);
				Combo combo = comboViewer.getCombo();
				combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				comboViewer.setContentProvider(TypeDefContentProvider.getInstance());
				comboViewer.setLabelProvider(TypeDefElementLabelProvider.getInstance());
				comboViewer.setInput(param.getTypedef());
				comboViewer.setSelection(new StructuredSelection(param.getTypedefelement()), true);
				comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
					
					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						// TODO Auto-generated method stub
						dirtyParams.put(PublicParamEditorComposite.this.param, PublicParamEditorComposite.this);
					}
				});
			}
			
		}
		

	}
	
	public void updateValues() {
		updateValues(this.param);
	}
	
	public void updateValues(MechanicPublicParam param) {
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			param.setDefaultvalue(text.getText());
		}
		else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				param.setTypedefelement(param.getTypedef().getElement(String.valueOf(button.getSelection())));
			}
			
			else {
				param.setTypedefelement((TypeDefElement) comboViewer.getStructuredSelection().getFirstElement());
			}
		}
	}
	/**
	 * this method is used after creation to set values from another param such as an option param
	 * @param param
	 * @param notifyChange whether to consider this change a user change and propagate the notifications
	 */
	public void setValues(MechanicPublicParam param,boolean notifyChange) {
		if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
		{
			text.setText(param.getDefaultvalue());
		}else if(param.getTypedef()!=null && param.getTypedefelement()!=null) {
			if(param.getTypedef().getKey().contentEquals("BOOLEAN")) {
				button.setSelection(Boolean.valueOf(param.getTypedefelement().getKey()));
			}else {
				comboViewer.setSelection(new StructuredSelection(param.getTypedefelement()), true);
			}
		}
		if(notifyChange)
		{
			dirtyParams.put(this.param, this);
		}
		
	}
}
