package dressing.ui;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.WorkspaceConfiguration;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.util.DesignELementMaterialComposite;
import dressing.ui.util.ImageLoaderCache;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.Vertice3;

public class ListPieceModelComoposite extends Composite {
	private Composite pieceMaterialComposite;
	public Map<MechanicDesignElment, MechanicDesignElment> elmentMaterialsEditors=new HashMap<MechanicDesignElment, MechanicDesignElment>();
	private MechanicDesign design;
	private Table table;
	private TableColumn tblclmnName;
	private TableViewerColumn tableViewerColumnMaterial;
	private TableColumn tblclmnMaterial;
	private TableViewerColumn tableViewerColumnName;
	private Composite tablepieceMaterialComposite;
	private TableViewerColumn tableViewerColumnMaterialType;
	private TableColumn tblclmnMaterialType;
	private TableViewerColumn tableViewerColumnMaterialReference;
	private TableColumn tblclmnMaterialReference;
	private TableViewerColumn tableViewerColumnTexure;
	private TableColumn tblclmnTexture;
	private Label lblName;
	private DesignELementMaterialComposite elementMaterialComposite;
	private TableViewer tableViewer;
	private DesignObject3D rootspace;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 * @param rootspace 
	 */
	public ListPieceModelComoposite(Composite parent, int style,MechanicDesign design, DesignObject3D rootspace) {
		super(parent, style);
		this.design=design;
		this.rootspace=rootspace;
		if(design!=null) {
			for(MechanicDesignElment element:this.design.getMechanicelementgroup().getMechanicdesignelment()) {
				if(element!=null ) {
					MechanicDesignCreator.getInstance().updateDesignElement(design, element, null);
				}
			}
		}
		
		setLayout(new GridLayout(1, false));
		
		tablepieceMaterialComposite = new Composite(this, SWT.NONE);
		tablepieceMaterialComposite.setLayout(new GridLayout(1, false));
		tablepieceMaterialComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		//
		createTablePiece();
		//
		pieceMaterialComposite = new Composite(this, SWT.NONE);
		pieceMaterialComposite.setLayout(new GridLayout(8, false));
		pieceMaterialComposite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 8, 1));
		lblName = new Label(pieceMaterialComposite, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblName.setText("Piece");
		elementMaterialComposite = new DesignELementMaterialComposite(pieceMaterialComposite, null, SWT.BORDER);
		GridData gd_elementComposite = new GridData(SWT.FILL, SWT.CENTER, true, false, 7, 1);
		elementMaterialComposite.setLayoutData(gd_elementComposite);
		
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
		    public void selectionChanged(SelectionChangedEvent event) {
			      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
			      // set the selection to the service
			      Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toList();
			      if(selectionobj instanceof MechanicDesignElment) {
			    	  MechanicDesignElment element=(MechanicDesignElment) selectionobj;
			    	  if((elementMaterialComposite.isDirty() ||elementMaterialComposite.getElementMaterialType().isDirty()) 
			    			  && !elementMaterialComposite.isDisposed()&& elementMaterialComposite.getElement()!=null && elementMaterialComposite.getOrigin()!=null) {
			    		  if(elementMaterialComposite.getElementMaterialType().isDirty()) {
								MaterialTypeInstance material=elementMaterialComposite.getElementMaterialType().getMaterial();
								MaterialTypeInstance elementMaterialType =elementMaterialComposite.getElement().getMaterialType();
								elementMaterialType.setIsColor(material.isIsColor());
								elementMaterialType.setMaterial(material.getMaterial());
								elementMaterialType.setTexture(elementMaterialComposite.getElementMaterialType().getSelectedTexture());
								if(elementMaterialComposite.getElementMaterialType().getColorComposite().isDirty())
								{
									elementMaterialType.setColor(elementMaterialComposite.getElementMaterialType().getColorComposite().getEmfColor());
								}
							}
			    		  elmentMaterialsEditors.putIfAbsent(elementMaterialComposite.getOrigin(), elementMaterialComposite.getElement());
			    	  }
			    	  lblName.setText(element.getName());
			    	  elementMaterialComposite.setElement(element);
			    	  tableViewer.refresh();
			      }
			    
			    }
			  });		
		
		elmentMaterialsEditors.clear();
		if(this.design!=null && this.design.getMechanicelementgroup().getMechanicdesignelment().size()>0)
		{
			tableViewer.setSelection(new StructuredSelection(this.design.getMechanicelementgroup().getMechanicdesignelment().get(0)), true);
		}

	}
	public void createTablePiece() {
		tableViewer = new TableViewer(tablepieceMaterialComposite,SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		tableViewerColumnName = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnName.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				if(element !=null && element instanceof MechanicDesignElment 
						&& ((MechanicDesignElment)element).getMaterialType()!=null &&((MechanicDesignElment)element).getMaterialType().getTexture()!=null &&!((MechanicDesignElment)element).getMaterialType().getTexture().isEmpty() 
						&& !((MechanicDesignElment)element).getMaterialType().isIsColor()) {
					String pp="pictures/";
					SceneTexture texture = ModelProvider.getTexture(((MechanicDesignElment)element).getMaterialType().getTexture());
					if(texture != null) {
						return texture.getLabelImage();
					}
				}
				return  null;//new Image(getDisplay(), 64, 32);
			}
			public String getText(Object element) {
				if(element !=null && element instanceof MechanicDesignElment ) {
					return ((MechanicDesignElment)element).getName();
				}
				return "";
			}
		});
		tblclmnName = tableViewerColumnName.getColumn();
		tblclmnName.setMoveable(true);
//		tblclmnName.setWidth(200);
		tblclmnName.setText("Nom");
		tblclmnName.setImage(null);
		tableViewerColumnMaterial = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnMaterial.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof MechanicDesignElment && ((MechanicDesignElment)element).getMaterial()!=null ) {
					return ((MechanicDesignElment)element).getMaterial().getName();
				}
				return element == null ? "" : element.toString();
			}
		});
		
		tblclmnMaterial = tableViewerColumnMaterial.getColumn();
		tblclmnMaterial.setMoveable(true);
//		tblclmnMaterial.setWidth(200);
		tblclmnMaterial.setText("Matériau");
		

		tableViewerColumnMaterialType = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnMaterialType.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof MechanicDesignElment 
						&& ((MechanicDesignElment)element).getMaterialType()!=null &&((MechanicDesignElment)element).getMaterialType().getMaterial()!=null ) {
					return ((MechanicDesignElment)element).getMaterialType().getMaterial().getName();
				}
				return element == null ? "" : element.toString();
			}
		});
		
		tblclmnMaterialType = tableViewerColumnMaterialType.getColumn();
		tblclmnMaterialType.setMoveable(true);
//		tblclmnMaterialType.setWidth(200);
		tblclmnMaterialType.setText("Type Matériau");
		tableViewerColumnMaterialReference = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnMaterialReference.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof MechanicDesignElment ) {
					if(((MechanicDesignElment)element).isFreeMaterial()) {
						return "Libre";
					}
					if(((MechanicDesignElment)element).isFaceMaterial()) {
						return "Facade";
					}
					if(((MechanicDesignElment)element).isPrimaryMaterial()) {
						return "Elément";
					}
					if(((MechanicDesignElment)element).isBackMaterial()) {
						return "Dos";
					}
				}
				return element == null ? "" : element.toString();
			}
		});
		
		tblclmnMaterialReference = tableViewerColumnMaterialReference.getColumn();
		tblclmnMaterialReference.setMoveable(true);
//		tblclmnMaterialReference.setWidth(200);
		tblclmnMaterialReference.setText("Matériau Référence");
		tableViewerColumnTexure = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnTexure.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				
				return null;
			}
			
			@Override
			public Color getBackground(Object element) {
				if(element !=null && element instanceof MechanicDesignElment 
						&& ((MechanicDesignElment)element).getMaterialType()!=null && ((MechanicDesignElment)element).getMaterialType().isIsColor() && ((MechanicDesignElment)element).getMaterialType().getColor()!=null) {
					Vertice3 color =((MechanicDesignElment)element).getMaterialType().getColor();
					return new Color(Display.getCurrent(), (new RGBA((int)(color.getR()*255), (int)(color.getG()*255), (int)(color.getB()*255),  (int)(color.getA()*255))));
				}
				return super.getBackground(element);
			}
			@Override
			public Color getForeground(Object element) {
				if(element !=null && element instanceof MechanicDesignElment 
						&& ((MechanicDesignElment)element).getMaterialType()!=null && ((MechanicDesignElment)element).getMaterialType().isIsColor() && ((MechanicDesignElment)element).getMaterialType().getColor()!=null) {
					Vertice3 color =((MechanicDesignElment)element).getMaterialType().getColor();
					return new Color(Display.getCurrent(), (new RGBA((int)(color.getR()*255), (int)(color.getG()*255), (int)(color.getB()*255),  (int)(color.getA()*255))));
				}
				return super.getForeground(element);
			}
			public String getText(Object element) {
				if(element !=null && element instanceof MechanicDesignElment 
						&& ((MechanicDesignElment)element).getMaterialType()!=null &&((MechanicDesignElment)element).getMaterialType().getTexture()!=null &&!((MechanicDesignElment)element).getMaterialType().getTexture().isEmpty()&& !((MechanicDesignElment)element).getMaterialType().isIsColor()) {
					SceneTexture texture = ModelProvider.getTexture(((MechanicDesignElment)element).getMaterialType().getTexture());
					if(texture!=null && texture.getLabelImage()!=null) {
						
						return new File(texture.getPath()).getName();
					}
					return ((MechanicDesignElment)element).getMaterialType().getTexture();
				}
				return  "" ;
			}
		});
		
		tblclmnTexture = tableViewerColumnTexure.getColumn();
		tblclmnTexture.setMoveable(true);
//		tblclmnTexture.setWidth(200);
		tblclmnTexture.setText("Texture");
		//
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		//
		List<MechanicDesignElment > designElements=new ArrayList<MechanicDesignElment>();
		if(this.design!=null)
		{
			designElements=this.design.getMechanicelementgroup().getMechanicdesignelment();
		}
		if(this.rootspace!=null && this.rootspace.getChilds()!=null && !this.rootspace.getChilds().isEmpty() && !(this.rootspace instanceof Piece2D)) {
			List<MechanicDesignElment > elements = new ArrayList<MechanicDesignElment>();
			for(DesignObject3D child:this.rootspace.getChilds()) {
				if(child!=null && child instanceof Piece2D &&((Piece2D)child).getMechanicDesignElementDefinition()!=null && designElements.contains(((Piece2D)child).getMechanicDesignElementDefinition())) {
					elements.add(((Piece2D)child).getMechanicDesignElementDefinition())	;
				}
			}
			tableViewer.setInput(elements);
		}else
		{
			tableViewer.setInput(designElements);
		}
		//
		//
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = tablepieceMaterialComposite.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.width + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		       
		      }
		      Point vBarSize = table.getVerticalBar().getSize();
		      Point hBarSize = table.getHorizontalBar().getSize();

		        width -= vBarSize.x;
		        width-=300;
		        int width2=150;
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	tblclmnName.setWidth(width/3);
		        tblclmnMaterialReference.setWidth(width2);
		        tblclmnMaterialType.setWidth(width2);
		        tblclmnTexture.setWidth(width/3);
		        tblclmnMaterial.setWidth(width/3);
		        table.setSize(area.width, area.height);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height);
		        tblclmnName.setWidth(width/3);
		        tblclmnMaterialReference.setWidth(width2);
		        tblclmnMaterialType.setWidth(width2);
		        tblclmnTexture.setWidth(width/3);
		        tblclmnMaterial.setWidth(width/3);

		      }
		      
		    }};
		this.addControlListener(cal);
		tablepieceMaterialComposite.addControlListener(cal);
//		table.pack();
//		table.redraw();
//		tablepieceMaterialComposite.requestLayout();
	}
	public boolean updateValues() {
		//
		boolean changed=false;
		if(elmentMaterialsEditors!=null && !elmentMaterialsEditors.isEmpty()) {
			for(MechanicDesignElment element :elmentMaterialsEditors.keySet()) {
				MechanicDesignElment copy =elmentMaterialsEditors.get(element);
				if(copy!=null) {
					
					element.setMaterial(copy.getMaterial());
					element.setFreeMaterial(copy.isFreeMaterial());
					
					element.setFaceMaterial(copy.isFaceMaterial());
					element.setPrimaryMaterial(copy.isPrimaryMaterial());
					element.setBackMaterial(copy.isBackMaterial());
					element.setMaterialType(copy.getMaterialType());
					changed=true;
				}
			}
		}
		 if((elementMaterialComposite.isDirty() ||elementMaterialComposite.getElementMaterialType().isDirty()) 
   			  && !elementMaterialComposite.isDisposed()&& elementMaterialComposite.getElement()!=null && elementMaterialComposite.getOrigin()!=null) {
			 MechanicDesignElment element=elementMaterialComposite.getOrigin();
			 MechanicDesignElment copy=elementMaterialComposite.getElement();
			 element.setMaterial(copy.getMaterial());
				element.setFreeMaterial(copy.isFreeMaterial());
				
				element.setFaceMaterial(copy.isFaceMaterial());
				element.setPrimaryMaterial(copy.isPrimaryMaterial());
				element.setBackMaterial(copy.isBackMaterial());
				 if(elementMaterialComposite.getElementMaterialType().isDirty()) {
						MaterialTypeInstance material=elementMaterialComposite.getElementMaterialType().getMaterial();
						MaterialTypeInstance elementMaterialType =element.getMaterialType();
						elementMaterialType.setIsColor(material.isIsColor());
						elementMaterialType.setMaterial(material.getMaterial());
						elementMaterialType.setTexture(elementMaterialComposite.getElementMaterialType().getSelectedTexture());
						if(elementMaterialComposite.getElementMaterialType().getColorComposite().isDirty())
						{
							elementMaterialType.setColor(elementMaterialComposite.getElementMaterialType().getColorComposite().getEmfColor());
						}
					}
				 changed=true;
		 }
		 return changed;
	}
	
	public MechanicDesign getDesign() {
		return design;
	}
	public void setDesign(MechanicDesign design) {
		this.design = design;
	}
	public DesignObject3D getRootspace() {
		
		return rootspace;
	}
	public void setRootspace(DesignObject3D rootspace) {
		
		elmentMaterialsEditors.clear();
		this.rootspace = rootspace;
		this.design=rootspace.getMechanicDesignDefinition();
		this.rootspace=rootspace;
//		if(design!=null) {
//			for(MechanicDesignElment element:this.design.getMechanicelementgroup().getMechanicdesignelment()) {
//				if(element!=null ) {
//					MechanicDesignCreator.getInstance().updateDesignElement(design, element, null);
//				}
//			}
//		}
		List<MechanicDesignElment > designElements=new ArrayList<MechanicDesignElment>();
		if(this.design!=null)
		{
			designElements=this.design.getMechanicelementgroup().getMechanicdesignelment();
		}
		if(this.rootspace!=null && this.rootspace.getChilds()!=null && !this.rootspace.getChilds().isEmpty() && !(this.rootspace instanceof Piece2D)) {
			List<MechanicDesignElment > elements = new ArrayList<MechanicDesignElment>();
			for(DesignObject3D child:this.rootspace.getChilds()) {
				if(child!=null && child instanceof Piece2D &&((Piece2D)child).getMechanicDesignElementDefinition()!=null && designElements.contains(((Piece2D)child).getMechanicDesignElementDefinition())) {
					elements.add(((Piece2D)child).getMechanicDesignElementDefinition())	;
					MechanicDesignCreator.getInstance().updateDesignElement(design, ((Piece2D)child).getMechanicDesignElementDefinition(), (Piece2D)child);

				}
			}
			tableViewer.setInput(elements);
		}else
		{
			tableViewer.setInput(designElements);
		}
		if(designElements.size()>0)
		{
			tableViewer.setSelection(new StructuredSelection(designElements.get(0)), true);
		}
		tableViewer.refresh();
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
