package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Finition;
import param.ParamFactory;

public class FinitionsComboSelect extends ElementComboSelect {

	public FinitionsComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getGestion().getFinitions().getFinitions());
		return input;
	}

	@Override
	public void addElement() {
		Finition finition=ParamFactory.eINSTANCE.createFinition();
		finition.setName("");
		FinitionEditorWindow finitionEditorWindow = new FinitionEditorWindow(getShell(),finition,EditorWindow.create);
		finitionEditorWindow.create();
		int ret=finitionEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(finition), true);
		}
	}

//	@Override
//	public void listElements() {
//		FinitionsListWindow frsListWindow = new FinitionsListWindow(getShell(),null);
//		frsListWindow.create();
//		int ret=frsListWindow.open();
//		getComboViewer().setInput(getinput());
//		getComboViewer().refresh();
//	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Finition) {
			Finition finition=(Finition) selection;
			FinitionEditorWindow finitionEditorWindow = new FinitionEditorWindow(getShell(),finition,EditorWindow.update);
			finitionEditorWindow.create();
			int ret=finitionEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new FinitionsListWindow(getShell(),null);
	}
}
