package dressing.model.debitage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.config.persistence.ResourceManagers;
import dressing.model.Delimeter;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.stock.Article;
import param.AccessoireInstance;
import param.Cavity;
import param.CondtionalEquation;
import param.ImportedParams;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.Parameters;
import param.QuincaillerieInstance;
import param.Rainure;
import param.UsinageTrou;
import param.delimeterInstance;

public class DelimeterGenericDebitageFormula extends GenericDebitageFormula {

	public DelimeterGenericDebitageFormula() {
		// TODO Auto-generated constructor stub
		super();
	}

	public static void filldebitagesequations(DesignObject3D parent, Delimeter delimeter, Object emf,List<MechanicPrivateParam> privateparams,
			List<MechanicPublicParam> publicparams, ArrayList<Equation> equations) throws DesignException {
		if (delimeter == null)
			throw new DesignException("Formule de debitage : delimeter null");
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		if (parent != null) {
			GeomtericEngine.getLogicalEngine().put("PARENT", parent);
			GeomtericEngine.getLogicalEngine().put("CHILD", delimeter);
			for (Entry<Object, Object> prop : parent.entrySet()) {
				if (prop.getKey().toString().startsWith("$")) {
					try {
						GeomtericEngine.getLogicalEngine().eval(parent.get(prop.getKey()).toString());
						GeomtericEngine.getEngine().eval(parent.get(prop.getKey()).toString());
					} catch (ScriptException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new DesignException("La fonction " + prop.getKey().toString() + " cannot be evaluated");
					}
				} else {
					GeomtericEngine.getLogicalEngine().put((String) prop.getKey(), parent.get(prop.getKey()));
				}

			}
		}

		// check exist logic
		try {
			if(ResourceManagers.getIntance().getApplication().getParametersgroups()!=null && ResourceManagers.getIntance().getApplication().getParametersgroups().getParameters()!=null)
			{
				FILL_USINAGE(ResourceManagers.getIntance().getApplication().getParametersgroups().getParameters(),equations);
			}
			fillequationsfromprivateparam(equations, privateparams);
			fillequationsfrompublicparam(equations, publicparams);
			fillequationsfromparent(parent, equations);
			fillequationsfromemfmodel(equations, emf);
			boolean res = true;
			if(emf instanceof param.Delimeter)
			{
				param.Delimeter elment = ((param.Delimeter)emf);
				if(elment.getExistExpression()!=null && !elment.getExistExpression().isEmpty())
				{
					String existExpression = elment.getExistExpression();
					res = (boolean) GeomtericEngine.getLogicalEngine().eval(existExpression);
				}
			}
			delimeter.put("EXIST", res);


		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			delimeter.put("EXIST", false);
			throw new DesignException(
					" Existence expression cannot be evaluated " + delimeter.get("EXIST_EXPRESSION").toString());
		} finally {
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		}

	}

	private static void fillequationsfromemfmodel(ArrayList<Equation> equations, Object emf) throws DesignException {

		if (emf instanceof param.Delimeter) {
			List<param.Equation> articleEquationequations = new ArrayList<param.Equation>();
			articleEquationequations.add(((param.Delimeter) emf).getPositionEquation());
			fillequationsfromgenericequations(equations, articleEquationequations);
		}
	}
	
	protected static void FILL_USINAGE(EList<Parameters> eList,ArrayList<Equation> equations) {
		if(eList!=null) {
			for(Parameters param:eList) {
				if(param!=null&& param.getCode()!=null&& param.getValue()!=null) {
					ADDOrUpdateEquation(param.getCode(),param.getValue() ,Equation.CALCULATION_MANUAL,equations);
				}
				
			}
		}
		
	}

}
