package dressing.cam.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.math.Vector3;

import dressing.config.persistence.ResourceManagers;
import dressing.model.Cavity;
import dressing.model.Piece2D;
import dressing.model.types.Orientation;
import param.cam.MachineEngine;
import param.cam.MachineHead;
import param.cam.MachineSides;
import param.Tool;
public abstract class GcodeGeneratorImp implements GcodeGenerator{
	public static final double epsilon=0.001;
	protected MachineHead getMachineHead(Usinage usin,MachineSides face) {
		MachineEngine machineEngine=ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		
		if (usin instanceof Trou) {
			List<MachineHead> heads=new ArrayList<MachineHead>();
			for(MachineHead head:machineEngine.getHeads()) {
				if(head.getSides().equals(face)) {
					heads.add(head);
				}
			}
			for (MachineHead head : heads) {
				if (head.isVerticaleHole()) {
					return head;
				}
			}
		}
		if (face.equals(MachineSides.FACE)&&usin instanceof Rainure && (machineEngine.getRainurePreferredHead().isFreize()
				|| machineEngine.getRainurePreferredHead().isDisque())) {
			return machineEngine.getRainurePreferredHead();
		} else {
			if(face.equals(MachineSides.FACE)&&machineEngine.getCavitiesPreferredHead().isFreize()) {
				return machineEngine.getCavitiesPreferredHead();
			}
		}
		return null;
	}

	protected Tool getTool(Usinage usin, MachineHead head,MachineSides face) {
		if (head != null && head.getTools() != null && head.getTools().getTools() != null) {

			List<Tool> tools = head.getTools().getTools();

			Tool opTool = null;

			for (Tool tt : tools) {

				if (opTool == null) {
					opTool = tt;
					continue;
				}
				if (usin instanceof Trou) {
					Trou trou = (Trou) usin;
					if (Math.abs(tt.getCutterDiameter() - trou.getDiameter()) < Math
							.abs(opTool.getCutterDiameter() - trou.getDiameter())) {
						opTool = tt;
					}
				} else if (usin instanceof Cavity) {
					MachineEngine machineEngine = ResourceManagers.getIntance().getPreference().getConfig().getEngine();

					opTool = machineEngine.getFreizePreferredTool();
				}
			}

			return opTool;
		}
		return null;
	}
	protected Tool getTool(Rainure usin, MachineHead head, float width) {
		MachineEngine machineEngine = ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		if(machineEngine.getRainurePreferredTool()!=null 
				&&Math.abs(machineEngine.getRainurePreferredTool().getCutterDiameter()-width)<GcodeGeneratorImp.epsilon ) {
			return machineEngine.getRainurePreferredTool();
		}
		List<Tool> tools=head.getTools().getTools();
		
		Tool opTool=null;
		for (Tool tt : tools) {
			if (opTool == null) {
				opTool = tt;
				continue;
			}
			if (Math.abs(tt.getCutterDiameter() - width) < Math.abs(opTool.getCutterDiameter() - width)) {
				opTool = tt;
			}
		}
		if(opTool==null) {
			return head.getTools().getTools().get(0);
		}
		return opTool;
	}

	public MachineSides getTrouface(Vector3 start,Vector3 end) {
		MachineSides face = MachineSides.FACE;
		if (start.x < end.x)
			face = MachineSides.LEFT;
		if (start.x > end.x)
			face = MachineSides.RIGHT;
		if (start.y < end.y)
			face = MachineSides.BOTTOM;
		if (start.y >end.y)
			face = MachineSides.TOP;
		
		return face;
	}
	protected Vector3[] sortVertices(ArrayList<Vector3> vertices, Vector3 piece) {
		Vector3 p1, p2, p3, p4;
		float minX = 10000, maxX = 0, minY = 10000, maxY = 0;
		for (Vector3 point : vertices) {
			if (point.x < minX)
				minX = point.x;
			if (point.x > maxX)
				maxX = point.x;
			if (point.y < minY)
				minY = point.y;
			if (point.y > maxY)
				maxY = point.y;
		}

		p1 = new Vector3(minX, minY, piece.z);
		p2 = new Vector3(maxX, minY, piece.z);
		p3 = new Vector3(maxX, maxY, piece.z);
		p4 = new Vector3(minX, maxY, piece.z);

		return new Vector3[] { p1, p2, p3, p4 };
	}
	protected int getCheek(Usinage usin, Orientation orientation, Piece2D piece) {
		int cheek = -1;
		if(usin instanceof Trou) {
			Trou trou = (Trou) usin;
			Direction direction = trou.getDirection();
			if(orientation == Orientation.HORIZONTAL){
				switch(direction){
				case YMINUS:
					cheek  = 0;
					break;
				case YPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}else if(orientation == Orientation.VERTICAL) {
				switch(direction){
				case XMINUS:
					cheek = 0;
					break;
				case XPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}else {
				switch(direction){
				case ZMINUS:
					cheek = 0;
					break;
				case ZPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}
		}
		if (usin instanceof Rainure) {
			Rainure rainure = (Rainure) usin;
			if(orientation == Orientation.VERTICAL) {
				cheek = 0;
				if(rainure.getXpos() == 0 )
				{
					cheek = 1;
				}else if(rainure.getXpos()+rainure.getLongeurext()== piece.getLongeurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}else if(orientation == Orientation.HORIZONTAL){
				cheek = 1;
				if(rainure.getYpos() == 0)
				{
					cheek = 1;
				}else if(rainure.getYpos()+rainure.getHauteurext()==piece.getHauteurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}else {
				cheek = 0;
				if(rainure.getZpos()==0)
				{
					cheek=1;
				}else if(rainure.getZpos()+rainure.getProfondeurext()==piece.getProfondeurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}
		}
		return cheek;
	}
}
