package supercad.persistence.databinding;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public class DateTimeValueMapper implements CustomValueMapper<LocalDateTime> {

	private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
	
	@Override
	public String write(LocalDateTime value) {
		
		return value.format(formatter);
	}

	@Override
	public LocalDateTime read(String text, Class<? extends LocalDateTime> clazz) {
		return LocalDateTime.parse(text, formatter);
	}
	
}
