package dressing.ui;

import gdxapp.object3d.WorldObject;

public class RotateCommand implements ChangeCommand {

	String name;
	String description;
	WorldObject target;
	float oldRotation;
	float newRotation;
	
	public RotateCommand(String name, String description, WorldObject target, float oldRotation, float newRotation) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.oldRotation = oldRotation;
		this.newRotation = newRotation;
	}

	@Override
	public void redo() {
		if(target!=null){
			target.setRotation(newRotation);
			target.setRequireRefrech(true);
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(target!=null){
			target.setRotation(oldRotation);
			target.setRequireRefrech(true);
		}

	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}

	public float getOldRotation() {
		return oldRotation;
	}

	public void setOldRotation(float oldRotation) {
		this.oldRotation = oldRotation;
	}

	public float getNewRotation() {
		return newRotation;
	}

	public void setNewRotation(float newRotation) {
		this.newRotation = newRotation;
	}

	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		oldRotation=-1;
		newRotation=-1;
	}
}
