package tech.frsdev.j3d;

import java.io.File;
import java.io.IOException;
import java.util.Collections;

import javax.imageio.ImageIO;
import org.eclipse.ui.internal.quickaccess.CamelUtil;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.behaviors.vp.OrbitBehavior;
import org.jogamp.java3d.utils.geometry.Box;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

import dressing.config.WorkspaceConfiguration;

public class Room extends BranchGroup{

	private float xlongeur;
	private float yhauteur;
	private float zprofondeur;
	private double refsize=1;
	
	public Room(float xlongeur, float yhauteur, float zprofondeur) {
		super();
		this.xlongeur = xlongeur;
		this.yhauteur = yhauteur;
		this.zprofondeur = zprofondeur;
		init();
	}
	
	public Room(float xlongeur, float yhauteur, float zprofondeur,double refsize) {
		super();
		this.xlongeur = (float) (xlongeur/refsize);
		this.yhauteur = (float) (yhauteur/refsize);
		this.zprofondeur = (float) (zprofondeur/refsize);
		this.refsize = refsize;
		init();
	}
	
	private void init()
	{
		//floor
		{
			Appearance floorapperance =new Appearance();
		    floorapperance.setColoringAttributes(new ColoringAttributes (new Color3f (1.0f, 1.0f, 1.0f),1));
		    Box floor = new Box(xlongeur,0.001f, zprofondeur, Box.GENERATE_TEXTURE_COORDS , floorapperance);
		    TransformGroup tf = new TransformGroup();
		    Transform3D tf3 = new Transform3D();
		    tf3.setTranslation(new Vector3d(0, 0, zprofondeur));
		    tf.setTransform(tf3);
		    tf.addChild(floor);
		    this.addChild(tf);
		}

		//yop
//		{
//			Appearance floorapperance =new Appearance();
//		    floorapperance.setColoringAttributes(new ColoringAttributes (new Color3f (0.0f, 0.0f, 1.0f),1));
//		    Box floor = new Box(xlongeur,0.001f, zprofondeur,floorapperance);
//		    TransformGroup tf = new TransformGroup();
//		    Transform3D tf3 = new Transform3D();
//		    tf3.setTranslation(new Vector3d(0, yhauteur*2, zprofondeur));
//		    tf.setTransform(tf3);
//		    tf.addChild(floor);
//		    this.addChild(tf);
//		}
	     
	    //front
		{
			Appearance wallapperance = new Appearance();
			wallapperance.setColoringAttributes(new ColoringAttributes(new Color3f(0.0f, 1.0f, 0.0f), 1));
			Box wall = new Box(xlongeur, yhauteur, 0.001f,Box.GENERATE_TEXTURE_COORDS, wallapperance);

			TransformGroup tf = new TransformGroup();
			Transform3D tf3 = new Transform3D();
			tf3.setTranslation(new Vector3d(0, yhauteur, 0));
			tf.setTransform(tf3);
			tf.addChild(wall);

			this.addChild(tf);
		}

		//gauche
		{
			Appearance wallapperance = new Appearance();
			wallapperance.setColoringAttributes(new ColoringAttributes(new Color3f(0.3f, .3f, 0.6f), 1));
			Box wall = new Box(0.001f, yhauteur, zprofondeur,Box.GENERATE_TEXTURE_COORDS, wallapperance);
			TransformGroup tf = new TransformGroup();
			Transform3D tf3 = new Transform3D();
			tf3.setTranslation(new Vector3d(-xlongeur, yhauteur, zprofondeur));
			tf.setTransform(tf3);
			tf.addChild(wall);

			this.addChild(tf);
		}
		
		//droite
//		{
//			Appearance wallapperance = new Appearance();
//			wallapperance.setColoringAttributes(new ColoringAttributes(new Color3f(0.3f, .3f, 0.6f), 1));
//			Box wall = new Box(0.001f, yhauteur, zprofondeur,Box.GENERATE_TEXTURE_COORDS, wallapperance);
//
//		    try {
//				Texture texImage = new TextureLoader(ImageIO.read(new File("c:/textures/wallbreak.jpg"))).getTexture();
//				texImage.setEnable(true);
//				
//				texImage.setMagFilter(Texture.BASE_LEVEL_LINEAR);
//				texImage.setMinFilter(Texture.BASE_LEVEL_LINEAR);
//				wallapperance.setTexture(texImage);
//		
//				TextureAttributes textureAt = new TextureAttributes();
//				textureAt.setTextureMode(TextureAttributes.REPLACE);
//				wallapperance.setTextureAttributes(textureAt);
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			TransformGroup tf = new TransformGroup();
//			Transform3D tf3 = new Transform3D();
//			tf3.setTranslation(new Vector3d(xlongeur, yhauteur, zprofondeur));
//			tf.setTransform(tf3);
//			tf.addChild(wall);
//
//			this.addChild(tf);
//		}
	     
	}
	public float getXlongeur() {
		return xlongeur;
	}
	public void setXlongeur(float xlongeur) {
		this.xlongeur = xlongeur;
	}
	public float getYhauteur() {
		return yhauteur;
	}
	public void setYhauteur(float yhauteur) {
		this.yhauteur = yhauteur;
	}
	public float getZprofondeur() {
		return zprofondeur;
	}
	public void setZprofondeur(float zprofondeur) {
		this.zprofondeur = zprofondeur;
	}

	public static void main(String[] args) {

		   System.setProperty("sun.awt.noerasebackground", "true");

		   SimpleUniverse universe = new SimpleUniverse();
		   universe.getViewer().getView().setSceneAntialiasingEnable(true);
		   // Create a structure to contain objects

		   BranchGroup group = new BranchGroup();
		   
		   group.addChild(new Room(1f, 1f, 1f));
		   
		   Sphere sphere = new Sphere(0.1f);

		   Appearance sphereAppearance =new Appearance();
		   sphereAppearance.setColoringAttributes(new ColoringAttributes (new Color3f (1.0f, 0.0f, 0.0f),1));
		   sphere.setAppearance(sphereAppearance);
		   group.addChild(sphere);
		   universe.getViewingPlatform().setNominalViewingTransform();

		   // add the group of objects to the Universe

		   universe.addBranchGraph(group);
		   
		   
			OrbitBehavior orbiter = new OrbitBehavior();			
			BoundingSphere worldBounds = new BoundingSphere( new Point3d( 0f,0f,0f ) , 0.0 );
			orbiter.setSchedulingBounds( worldBounds );
			universe.getViewingPlatform().setViewPlatformBehavior( orbiter );
			
			 Transform3D         viewingTransform = new Transform3D();
			 TransformGroup viewingTransformGroup= universe.getViewingPlatform().getViewPlatformTransform();

		     viewingTransform.lookAt(new Point3d( 0f,0.25f,1f ), new Point3d(0f,0f,0f), new Vector3d(0, 1, 0));
		     viewingTransform.invert();
		     viewingTransformGroup.setTransform(viewingTransform);
		    

	}
}