package gdxapp.screens.room;


import org.apache.lucene.search.ControlledRealTimeReopenThread;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.quotation.QuotationSorter;
import gdxapp.scenes.SceneEvent;


public class RoomScreen extends AbstractScreen{
	
    public static final String TAG = RoomScreen.class.getName();
    private RoomController roomController;
	private static RoomScreen instance;	
	
    public RoomScreen(){
        roomController =  RoomController.getInstance();
    }
    public static RoomScreen getInstance() {
 		synchronized(RoomScreen.class) {
 			if (instance == null) {
 				instance = new RoomScreen();
 			}
 			return instance;
 		}
 	}
    @Override
    public void show() {
    	roomController.getChangeCommandController().clear();
        Gdx.input.setInputProcessor(roomController.inputMultiplexer);
        roomController.reloadActors();
        roomController.subscribe(SceneEvent.OBJECT_DROP.name());
        roomController.setHandle(true);
    }

    @Override
    public void render(float delta) {
    	try {
    		AssetsTextures.getInstance().prepareMaterials();
    		this.roomController.resolveMarbleExtrusion();
            Gdx.gl.glClearColor(0xFA / 255.0f, 0xFA / 255.0f,0xFA / 255.0f, 0xff / 255.0f);
            Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
            
            roomController.stage.draw();
            roomController.createQuotations();
            QuotationSorter.getInstance().draw(roomController.stage.getBatch());
            if(roomController.getSelectedSurface() != null) {
            	Surface surface = roomController.getSelectedSurface(); 
            	Vector3 s = surface.getStart().cpy().add(surface.getEnd()).scl(.5f).mul(roomController.getSceneToWorldTransform().inv());
            	Vector3 e = s.cpy().add(surface.getNormal().cpy().mul(new Matrix3().set(roomController.getWorldToSceneTransform())).nor().scl(50));
            	DrawingHelper.drawLine(new Vector2(s.x,s.y), new Vector2(e.x, e.y), roomController.getStage().getBatch(), Color.BLUE, 3);
            }
            if(Gdx.input.isKeyPressed(Input.Keys.X)) {
            	roomController.drawCriticalPoints();
            }
    	}catch (Exception e) {
    		e.printStackTrace();
    		System.err.println("room screen crashed");
    		if(roomController.getStage().getBatch().isDrawing())
    			roomController.getStage().getBatch().end();
    		roomController.init();
    		roomController.reloadActors();
    	}
    	
    	roomController.uiStage.act();
    	roomController.uiStage.draw();

    	
    }	

    @Override
    public void resize(int width, int height) {
        roomController.stage.getViewport().update(width, height,true);
        roomController.uiStage.getViewport().update(width, height,true);
        roomController.resizeStage();
    }

    @Override
    public void pause() {

    }

    @Override
    public void resume() {

    }

    @Override
    public void hide() {
    	Object objects = ProjectManager.getManager().getCurrentScene().getSceneObjects();
    	objects.toString();
    	this.roomController.updateActorsRealWorldPosition();
    	roomController.getChangeCommandController().clear();
    	Gdx.input.setInputProcessor(null);
    	roomController.unsubscribe(SceneEvent.OBJECT_DROP.name());
    	roomController.setHandle(false);
    }

    @Override
    public void dispose() {
    	roomController.stage.dispose();
    }

    @Override
    public ScreenController getController() {
        return roomController;
    }
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		System.err.println("ROOM screen finalized");
	}
    
}
