package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;
import dressing.ui.util.ColorComposite;
import gdxapp.object3d.PlinthObject;

public class SocleSettingComposite extends Composite{

	
	private PlinthObject plinthObject;
	
	PropertyChangeListener colorListener = new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
				RGB rgb = (RGB) evt.getNewValue();
				Vector3 albedo = new Vector3(rgb.red / 255.0f, rgb.green/255.0f,rgb.blue / 255.0f);
				if(plinthObject != null)
					plinthObject.getGeometry().getBorder().getMaterial().setAlbedo(albedo);
		}
	};

	public SocleSettingComposite(Composite parent, int style, PlinthObject plinthObject) {
		super(parent, style);
		this.plinthObject = plinthObject;
		setLayout(new GridLayout(2, false));
		
		Label lblHauteur = new Label(this, SWT.NONE);
		lblHauteur.setText("Hauteur: ");
		
		Spinner spinner = new Spinner(this, SWT.BORDER);
		spinner.setMaximum(250);
		spinner.setMinimum(10);
		spinner.setSelection(Math.round(plinthObject.getHeight() * 1000));
		spinner.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float height = spinner.getSelection()/1000.0f;
				plinthObject.setHeight(height);
			}
		});
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEpaisseur = new Label(this, SWT.NONE);
		lblEpaisseur.setText("Épaisseur: ");
		
		Spinner spinner_1 = new Spinner(this, SWT.BORDER);
		spinner_1.setMinimum(10);
		spinner_1.setSelection(Math.round(plinthObject.getThickness() * 1000));
		spinner_1.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plinthObject.setThickness(spinner_1.getSelection() / 1000.0f);
			}
		});
		spinner_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCouleur = new Label(this, SWT.NONE);
		lblCouleur.setText("Couleur: ");
		
		ColorComposite colorComposite = new ColorComposite(this, SWT.NONE);
		colorComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		colorComposite.addColorListener(this.colorListener);
		
		colorComposite.setColor(plinthObject.getGeometry().getBorder().getMaterial().getAlbedo());

	}
}
