/*
 * Decompiled with CFR 0.152.
 */
package org.frs.supercad.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={ConfigurationManager.class})
public class ConfigurationManager {
    private Properties properties = new Properties();

    @Activate
    public void load() {
        try {
            String executionPath = System.getProperty("user.dir");
            Path configPath = Paths.get(executionPath, "configuration", "config.ini");
            File configFile = configPath.toFile();
            if (System.getProperty("osgi.dev") != null) {
                InputStream input = ConfigurationManager.class.getClassLoader().getResourceAsStream("config.properties");
                if (input != null) {
                    this.properties.load(input);
                } else {
                    System.err.println("ERREUR: Fichier config.proprietes non trouv\u00e9 dans le classpath!");
                }
            } else if (configFile.exists()) {
                this.properties.load(new FileInputStream(configFile));
            } else {
                System.err.println("ERREUR: Fichier Config.ini not found!");
                JOptionPane.showMessageDialog(null, "Fichier Config.ini not found!", "Attention", 2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            while (property.indexOf("%") >= 0) {
                int start = property.indexOf("%");
                String remainig = property.substring(start + 1);
                int end = remainig.indexOf("%") + start + 1;
                String variblale = property.substring(start, end + 1);
                String value = System.getProperty(variblale.replace("%", ""));
                property = property.replace(variblale, value);
            }
            return property.replace("/", "\\");
        }
        return null;
    }

    public String getRawProperty(String key) {
        return this.properties.getProperty(key);
    }
}

