/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class Quad
extends Mesh {
    private Vector3f[] corners = new Vector3f[4];
    private Vector3f normal;
    private Matrix4f relativeCS;
    private Mesh mesh;

    public Quad(Vector3f ... vertices) {
        super(new Mesh[0]);
        this.corners[0] = vertices[0];
        this.corners[1] = vertices[1];
        this.corners[2] = vertices[2];
        this.corners[3] = vertices[3];
        Vector3f T = new Vector3f((Vector3fc)this.corners[1]).sub((Vector3fc)this.corners[0]).normalize();
        Vector3f B = new Vector3f((Vector3fc)this.corners[2]).sub((Vector3fc)this.corners[0]).normalize();
        this.normal = new Vector3f((Vector3fc)T).cross((Vector3fc)new Vector3f((Vector3fc)B)).normalize();
        B = new Vector3f((Vector3fc)this.normal).cross((Vector3fc)T);
        Vector3f translation = new Vector3f((Vector3fc)this.corners[0]).mul(-1.0f);
        this.relativeCS = new Matrix4f((Vector4fc)new Vector4f((Vector3fc)T, 1.0f), (Vector4fc)new Vector4f((Vector3fc)B, 1.0f), (Vector4fc)new Vector4f((Vector3fc)this.normal, 1.0f), (Vector4fc)new Vector4f((Vector3fc)translation, 1.0f));
    }

    public void draw(Shader shader) {
        shader.setMat4("model", this.transform);
        shader.setMat3("normal", new Matrix4f((Matrix4fc)this.transform).normal().get3x3(new Matrix3f()));
        shader.bindMaterial((PbrMaterial)this.mtl);
        GL30.glBindVertexArray((int)this.VAO);
        GL11.glDrawElements((int)4, (int)this.indices.length, (int)5125, (long)0L);
        GL30.glBindVertexArray((int)0);
    }

    public Vector3f getCenter() {
        return new Vector3f((Vector3fc)this.corners[0]).add((Vector3fc)this.corners[1]).add((Vector3fc)this.corners[2]).add((Vector3fc)this.corners[3]).div(4.0f);
    }
}

