package resources;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IconsResource {

	private static final Map<String, Image> CACHE = new HashMap();

	public static final String RIGHT = "icons/right.png";
	public static final String RIGHT_ARROW = "right-arrow.png";
	public static final String ROTATE = "icons/rotate-64.png";

	public static Image getImage(String path) {
		if (CACHE.containsKey(path)) {
			Image image = CACHE.get(path);
			if (image != null && !image.isDisposed()) {
				return image;
			}
		}

		InputStream stream = IconsResource.class.getClassLoader().getResourceAsStream(path);
		if (stream == null) {
			throw new RuntimeException("Could not load resource: " + path);
		}

		Image image = new Image(getDisplay(), stream);
		CACHE.put(path, image);
		return image;
	}

	private static Display getDisplay() {
		Display current = Display.getCurrent();
		return (current != null) ? current : Display.getDefault();
	}

	public static void disposeAll() {
		for (Image image : CACHE.values()) {
			if (image != null && !image.isDisposed()) {
				image.dispose();
			}
		}
		CACHE.clear();
	}

}
