package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.MecahnicDesignAccesoireComposite;
import dressing.ui.editorWindows.ArticleEditorWindow;
import dressing.ui.editorWindows.ArticleInstanceEditorWindow;
import dressing.ui.editorWindows.EditorWindow;
import dressing.ui.parts.GdxPart;
import param.Accessoire;
import param.AccessoireInstance;
import param.AccessoiresPieces;
import param.ArticleInstance;
import param.ParamFactory;
import param.QuicailleriePieces;
import param.QuincaillerieInstance;
import param.TypeDef;
import param.TypeDefElement;
import param.Utilities;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.List;

import java.util.ArrayList;
import java.util.UUID;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Point;


public class LibraryConfigManager extends EditorWindow {
	private Composite clientArea;
	Utilities utils=ResourceManagers.getIntance().getApplication().getUtilities();
	private Button btnAjouter_Accesoires;
	private Button btnSupprimer_Accesoires;
	private ListViewer listViewerAccessoires;
	private Button btnSupprimerAccesoiresPieces;
	private ListViewer listViewer_AccessPieces;
	private Button btnAjouterPieces;
	private ListViewer listViewer_Pieces;
	private Button btnAjouter_Quinc;
	private Button btnSupprimer_Quinc;
	private ListViewer listViewer_Quinc;
	private Button btnSupprimer_PiecesQuincaillerie;
	private ListViewer listViewer_QuincPieces;
	private Button btnAjouter_PiecesQuincaillerie;
	private ListViewer listViewer_Pieces2;
	private AccessoiresPieces selectedAccessoire;
	private QuicailleriePieces selectedQuicaillerie;

	private static LibraryConfigManager instance;

	private java.util.List<TypeDefElement> includedPieceTypes=new ArrayList<TypeDefElement>();
	public static LibraryConfigManager getInstance() {
 		synchronized(LibraryConfigManager.class) {
 			if (instance == null) {
 				instance = new LibraryConfigManager(GdxPart.parentShell, EditorWindow.executeAction);
 				instance.create();
 				instance.constrainShellSize();
 			}
 			return instance;
 		}
 }
	public LibraryConfigManager(Shell parentShell, int update) {
		super(parentShell, update);
		// TODO Auto-generated constructor stub
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		TypeDef type=ModelProvider.getTypeDef("PieceType");
		includedPieceTypes.clear();
		includedPieceTypes.addAll(type.getTypedefelement());
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(1, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		TabFolder tabFolder = new TabFolder(clientArea, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		TabItem tbtmAccesoires = new TabItem(tabFolder, SWT.NONE);
		tbtmAccesoires.setText("Accesoires");
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(tabFolder, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		tbtmAccesoires.setControl(scrolledComposite);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		
		Composite composite = new Composite(scrolledComposite, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		
		SashForm sashForm = new SashForm(composite, SWT.BORDER | SWT.SMOOTH);
		sashForm.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		ScrolledComposite scrolledComposite_3 = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_3.setExpandHorizontal(true);
		scrolledComposite_3.setExpandVertical(true);
		
		Composite composite_3 = new Composite(scrolledComposite_3, SWT.NONE);
		composite_3.setLayout(new GridLayout(3, false));
		
		Label lblAccessoires = new Label(composite_3, SWT.NONE);
		lblAccessoires.setText("Accessoires");
		
		btnAjouter_Accesoires = new Button(composite_3, SWT.NONE);
		btnAjouter_Accesoires.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				AccessoireInstance accessoire = ParamFactory.eINSTANCE.createAccessoireInstance();
				ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.create,accessoire);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					AccessoiresPieces accessoiresPieces =ParamFactory.eINSTANCE.createAccessoiresPieces();
					accessoiresPieces.setAccessoires(accessoire);
					accessoiresPieces.setName(accessoire.getName());
					accessoiresPieces.setId(UUID.randomUUID());
					LibraryConfigManager.this.utils.getAccessoires().add(accessoiresPieces);
					listViewerAccessoires.refresh();
				}
			}
		});
		btnAjouter_Accesoires.setText("Ajouter");
		
		btnSupprimer_Accesoires = new Button(composite_3, SWT.NONE);
		btnSupprimer_Accesoires.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				AccessoiresPieces article = (AccessoiresPieces) listViewerAccessoires.getStructuredSelection().getFirstElement();
				if(article!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer Article!", "voulez vous suupprimer l'article "+article.getName()+"?!");
					if (confirm) {

						LibraryConfigManager.this.utils.getAccessoires().remove(article);

						listViewerAccessoires.refresh();
					}
				}
			}
		});
		btnSupprimer_Accesoires.setText("Supprimer");
		
		listViewerAccessoires = new ListViewer(composite_3, SWT.BORDER | SWT.V_SCROLL);
		List listAccess = listViewerAccessoires.getList();
		listAccess.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		scrolledComposite_3.setContent(composite_3);
		scrolledComposite_3.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		ScrolledComposite scrolledComposite_1 = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_1.setExpandHorizontal(true);
		scrolledComposite_1.setExpandVertical(true);
		
		Composite composite_2 = new Composite(scrolledComposite_1, SWT.NONE);
		composite_2.setLayout(new GridLayout(2, false));
		
		Label lblTypePiecesInclu = new Label(composite_2, SWT.NONE);
		lblTypePiecesInclu.setText("Type Pieces Inclus");
		
		btnSupprimerAccesoiresPieces = new Button(composite_2, SWT.NONE);
		btnSupprimerAccesoiresPieces.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		btnSupprimerAccesoiresPieces.setText("Supprimer");
		
		listViewer_AccessPieces = new ListViewer(composite_2, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		List list_AccessPieces = listViewer_AccessPieces.getList();
		list_AccessPieces.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		scrolledComposite_1.setContent(composite_2);
		scrolledComposite_1.setMinSize(composite_2.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		ScrolledComposite scrolledComposite_2 = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_2.setExpandHorizontal(true);
		scrolledComposite_2.setExpandVertical(true);
		
		Composite composite_1 = new Composite(scrolledComposite_2, SWT.NONE);
		composite_1.setLayout(new GridLayout(2, false));
		
		Label lblTypePieces = new Label(composite_1, SWT.NONE);
		lblTypePieces.setText("Type Pieces");
		
		btnAjouterPieces = new Button(composite_1, SWT.NONE);
		btnAjouterPieces.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		btnAjouterPieces.setText("Ajouter");
		
		listViewer_Pieces = new ListViewer(composite_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		List list_Pieces = listViewer_Pieces.getList();
		list_Pieces.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		scrolledComposite_2.setContent(composite_1);
		scrolledComposite_2.setMinSize(composite_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		sashForm.setWeights(new int[] {1, 1, 1});
		scrolledComposite.setContent(composite);
		scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		TabItem tbtmNewItem = new TabItem(tabFolder, SWT.NONE);
		tbtmNewItem.setText("Quincaillerie");
		
		ScrolledComposite scrolledComposite_4 = new ScrolledComposite(tabFolder, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_4.setExpandVertical(true);
		scrolledComposite_4.setExpandHorizontal(true);
		tbtmNewItem.setControl(scrolledComposite_4);
		
		Composite composite_4 = new Composite(scrolledComposite_4, SWT.NONE);
		composite_4.setLayout(new GridLayout(1, false));
		
		SashForm sashForm_1 = new SashForm(composite_4, SWT.BORDER | SWT.SMOOTH);
		sashForm_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		ScrolledComposite scrolledComposite_3_1 = new ScrolledComposite(sashForm_1, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_3_1.setExpandVertical(true);
		scrolledComposite_3_1.setExpandHorizontal(true);
		
		Composite composite_3_1 = new Composite(scrolledComposite_3_1, SWT.NONE);
		composite_3_1.setLayout(new GridLayout(3, false));
		
		Label lblQuicaillerie = new Label(composite_3_1, SWT.NONE);
		lblQuicaillerie.setText("Quicaillerie");
		
		btnAjouter_Quinc = new Button(composite_3_1, SWT.NONE);
		btnAjouter_Quinc.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				QuincaillerieInstance quincaillerie = ParamFactory.eINSTANCE.createQuincaillerieInstance();
				ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.create,quincaillerie);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					QuicailleriePieces quicailleriePieces =ParamFactory.eINSTANCE.createQuicailleriePieces();
					quicailleriePieces.setQuincailleries(quincaillerie);
					quicailleriePieces.setName(quincaillerie.getName());
					quicailleriePieces.setId(UUID.randomUUID());
					LibraryConfigManager.this.utils.getQuicailleries().add(quicailleriePieces);
					listViewerAccessoires.refresh();
					listViewer_Quinc.refresh();
				}
			}
		});
		btnAjouter_Quinc.setText("Ajouter");
		
		btnSupprimer_Quinc = new Button(composite_3_1, SWT.NONE);
		btnSupprimer_Quinc.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				QuicailleriePieces article = (QuicailleriePieces) listViewer_Quinc.getStructuredSelection().getFirstElement();
				if(article!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer Article!", "voulez vous suupprimer l'article "+article.getName()+"?!");
					if (confirm) {

						LibraryConfigManager.this.utils.getQuicailleries().remove(article);

						listViewer_Quinc.refresh();
					}
				}
			}
		});
		btnSupprimer_Quinc.setText("Supprimer");
		
		listViewer_Quinc = new ListViewer(composite_3_1, SWT.BORDER | SWT.V_SCROLL);
		List list_Quinc = listViewer_Quinc.getList();
		list_Quinc.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		scrolledComposite_3_1.setContent(composite_3_1);
		scrolledComposite_3_1.setMinSize(composite_3_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		scrolledComposite_3_1.setMinSize(new Point(238, 113));
		
		ScrolledComposite scrolledComposite_1_1 = new ScrolledComposite(sashForm_1, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_1_1.setExpandVertical(true);
		scrolledComposite_1_1.setExpandHorizontal(true);
		
		Composite composite_2_1 = new Composite(scrolledComposite_1_1, SWT.NONE);
		composite_2_1.setLayout(new GridLayout(2, false));
		
		Label lblTypePiecesInclu_1 = new Label(composite_2_1, SWT.NONE);
		lblTypePiecesInclu_1.setText("Type Pieces Inclus");
		
		btnSupprimer_PiecesQuincaillerie = new Button(composite_2_1, SWT.NONE);
		btnSupprimer_PiecesQuincaillerie.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		btnSupprimer_PiecesQuincaillerie.setText("Supprimer");
		
		listViewer_QuincPieces = new ListViewer(composite_2_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		List list_QuincPieces = listViewer_QuincPieces.getList();
		list_QuincPieces.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		scrolledComposite_1_1.setContent(composite_2_1);
		scrolledComposite_1_1.setMinSize(composite_2_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		scrolledComposite_1_1.setMinSize(new Point(213, 113));
		
		ScrolledComposite scrolledComposite_2_1 = new ScrolledComposite(sashForm_1, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite_2_1.setExpandVertical(true);
		scrolledComposite_2_1.setExpandHorizontal(true);
		
		Composite composite_1_1 = new Composite(scrolledComposite_2_1, SWT.NONE);
		composite_1_1.setLayout(new GridLayout(2, false));
		
		Label lblTypePieces_1 = new Label(composite_1_1, SWT.NONE);
		lblTypePieces_1.setText("Type Pieces");
		
		btnAjouter_PiecesQuincaillerie = new Button(composite_1_1, SWT.NONE);
		btnAjouter_PiecesQuincaillerie.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		btnAjouter_PiecesQuincaillerie.setText("Ajouter");
		
		listViewer_Pieces2 = new ListViewer(composite_1_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		List list_Pieces2 = listViewer_Pieces2.getList();
		list_Pieces2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		scrolledComposite_2_1.setContent(composite_1_1);
		scrolledComposite_2_1.setMinSize(composite_1_1.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		scrolledComposite_2_1.setMinSize(new Point(152, 113));
		sashForm_1.setWeights(new int[] {1, 1, 1});
		scrolledComposite_4.setContent(composite_4);
		scrolledComposite_4.setMinSize(composite_4.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		scrolledComposite_4.setMinSize(new Point(813, 156));
		createController();
		return clientArea;
	}

	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}
	@Override
	public boolean terminer() {
		ResourceManagers.getIntance().saveLibraryResource();
		finish();
		return true;
	}
	@Override
	protected void cancel() {
		// TODO Auto-generated method stub

	}
	
	public Utilities getUtils() {
		return utils;
	}

	public void setUtils(Utilities utils) {
		this.utils = utils;
	}

	public AccessoiresPieces getSelectedAccessoire() {
		return selectedAccessoire;
	}

	public void setSelectedAccessoire(AccessoiresPieces selectedAccessoire) {
		this.selectedAccessoire = selectedAccessoire;
	}

	public void createController() {
		listViewerAccessoires.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof AccessoiresPieces ) {
					if( ((AccessoiresPieces) element).getAccessoires()!=null)
					{
						return ((AccessoiresPieces) element).getAccessoires().getName();
					}else {
						return ((AccessoiresPieces) element).getName();
					}
				}
				return super.getText(element);
			}
		});
		listViewerAccessoires.setContentProvider(ArrayContentProvider.getInstance());
		listViewerAccessoires.setInput(utils.getAccessoires());
		listViewerAccessoires.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = listViewerAccessoires.getStructuredSelection();
				if(selection!=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof AccessoiresPieces) {
					selectedAccessoire =(AccessoiresPieces) selection.getFirstElement();
					listViewer_AccessPieces.setInput(selectedAccessoire.getPieceTypes());
					listViewer_Pieces.refresh();
				}
				
			}
		});
		listViewer_AccessPieces.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof TypeDefElement) {
					return ((TypeDefElement) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewer_AccessPieces.setContentProvider(ArrayContentProvider.getInstance());
		if(selectedAccessoire!=null)
		{
			listViewer_AccessPieces.setInput(selectedAccessoire.getPieceTypes());
		}
		listViewer_Pieces.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof TypeDefElement) {
					return ((TypeDefElement) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewer_Pieces.setContentProvider(ArrayContentProvider.getInstance());
		listViewer_Pieces.setInput(includedPieceTypes);
		listViewer_Pieces.addFilter(new ViewerFilter() {
			
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if(selectedAccessoire!=null && selectedAccessoire.getPieceTypes().contains(element))
				{
					return false;
				}else {
					return true;
				}
			}
		});
		//
		listViewer_Quinc.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof QuicailleriePieces ) {
					if( ((QuicailleriePieces) element).getQuincailleries()!=null)
					{
						return ((QuicailleriePieces) element).getQuincailleries().getName();
					}else {
						return ((QuicailleriePieces) element).getName();
					}
				}
				
				return super.getText(element);
			}
		});
		listViewer_Quinc.setContentProvider(ArrayContentProvider.getInstance());
		listViewer_Quinc.setInput(utils.getQuicailleries());
		listViewer_Quinc.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = listViewer_Quinc.getStructuredSelection();
				if(selection!=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof QuicailleriePieces) {
					selectedQuicaillerie =(QuicailleriePieces) selection.getFirstElement();
					listViewer_QuincPieces.setInput(selectedQuicaillerie.getPieceTypes());
					listViewer_Pieces2.refresh();
				}
				
			}
		});
		listViewer_QuincPieces.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof TypeDefElement) {
					return ((TypeDefElement) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewer_QuincPieces.setContentProvider(ArrayContentProvider.getInstance());
		if(selectedAccessoire!=null)
		{
			listViewer_QuincPieces.setInput(selectedQuicaillerie.getPieceTypes());
		}
		listViewer_Pieces2.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof TypeDefElement) {
					return ((TypeDefElement) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewer_Pieces2.setContentProvider(ArrayContentProvider.getInstance());
		listViewer_Pieces2.setInput(includedPieceTypes);
		listViewer_Pieces2.addFilter(new ViewerFilter() {
			
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if(selectedQuicaillerie!=null && selectedQuicaillerie.getPieceTypes().contains(element))
				{
					return false;
				}else {
					return true;
				}
			}
		});
		btnAjouter_PiecesQuincaillerie.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(selectedQuicaillerie!=null &&listViewer_Pieces2.getStructuredSelection()!=null 
						&& !listViewer_Pieces2.getStructuredSelection().isEmpty())
				{
					selectedQuicaillerie.getPieceTypes().addAll( listViewer_Pieces2.getStructuredSelection().toList());
					listViewer_QuincPieces.refresh();
					listViewer_Pieces2.refresh();
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		btnSupprimer_PiecesQuincaillerie.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(selectedQuicaillerie!=null &&listViewer_QuincPieces.getStructuredSelection()!=null 
						&& !listViewer_QuincPieces.getStructuredSelection().isEmpty())
				{
					selectedQuicaillerie.getPieceTypes().removeAll( listViewer_QuincPieces.getStructuredSelection().toList());
					listViewer_Pieces2.refresh();
					listViewer_QuincPieces.refresh();
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		//
		btnAjouterPieces.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(selectedAccessoire!=null &&listViewer_Pieces.getStructuredSelection()!=null 
						&& !listViewer_Pieces.getStructuredSelection().isEmpty())
				{
					selectedAccessoire.getPieceTypes().addAll( listViewer_Pieces.getStructuredSelection().toList());
					listViewer_AccessPieces.refresh();
					listViewer_Pieces.refresh();
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		btnSupprimerAccesoiresPieces.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(selectedAccessoire!=null &&listViewer_AccessPieces.getStructuredSelection()!=null 
						&& !listViewer_AccessPieces.getStructuredSelection().isEmpty())
				{
					selectedAccessoire.getPieceTypes().removeAll( listViewer_AccessPieces.getStructuredSelection().toList());
					listViewer_Pieces.refresh();
					listViewer_AccessPieces.refresh();
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
	}
}
